/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;
import org.overlord.commons.dev.server.util.ArchiveUtils;

public class WebAppModuleFromMavenGAVStrategy
extends AbstractModuleDiscoveryStrategy {
    private final String groupId;
    private final String artifactId;

    public WebAppModuleFromMavenGAVStrategy(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public String getName() {
        return "Maven Artifact (GAV)";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        block6: {
            URLClassLoader urlCL = (URLClassLoader)this.getClass().getClassLoader();
            TreeSet<URL> sortedURLs = new TreeSet<URL>(new Comparator<URL>(){

                @Override
                public int compare(URL o1, URL o2) {
                    return o1.toExternalForm().compareTo(o2.toExternalForm());
                }
            });
            sortedURLs.addAll(Arrays.asList(urlCL.getURLs()));
            String moduleUrl = null;
            String groupIdAsPath = this.groupId.replace('.', '/');
            for (URL url : sortedURLs) {
                String urlstr = url.toExternalForm();
                if (!urlstr.contains(groupIdAsPath) || !urlstr.contains("/" + this.artifactId + "-")) continue;
                moduleUrl = urlstr;
                break;
            }
            if (moduleUrl == null) {
                return null;
            }
            this.debug("Module URL: " + moduleUrl);
            try {
                String pathToWar = moduleUrl.replace("-classes.jar", ".war");
                URL warUrl = new URL(pathToWar);
                File war = new File(warUrl.toURI());
                this.debug("WAR: " + war);
                if (!war.isFile()) break block6;
                File workDir = new File(context.getTargetDir(), war.getName());
                this.debug("Work Dir: " + workDir);
                DevServerModule module = new DevServerModule();
                module.setInIDE(false);
                module.setWorkDir(workDir);
                module.setModuleDir(workDir);
                module.clean();
                workDir.mkdirs();
                try {
                    ArchiveUtils.unpackToWorkDir(war, workDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return module;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

