/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import java.io.IOException;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;
import org.overlord.commons.dev.server.util.ArchiveUtils;

public class WebAppModuleFromMavenDiscoveryStrategy
extends AbstractModuleDiscoveryStrategy {
    private final Class<?> someClass;

    public WebAppModuleFromMavenDiscoveryStrategy(Class<?> someClass) {
        this.someClass = someClass;
    }

    @Override
    public String getName() {
        return "Maven Artifact";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        String path = this.someClass.getClassLoader().getResource(this.someClass.getName().replace('.', '/') + ".class").getPath();
        if (path == null) {
            return null;
        }
        this.debug("Path: " + path);
        File file = new File(path);
        if (file.exists()) {
            return null;
        }
        if (path.contains("-classes.jar") && path.startsWith("file:")) {
            String pathToWar = path.substring(5, path.indexOf("-classes.jar")) + ".war";
            this.debug("Path to WAR: " + pathToWar);
            File war = new File(pathToWar);
            if (war.isFile()) {
                File workDir = new File(context.getTargetDir(), war.getName());
                this.debug("Work Dir: " + workDir);
                DevServerModule module = new DevServerModule();
                module.setInIDE(false);
                module.setWorkDir(workDir);
                module.setModuleDir(workDir);
                module.clean();
                workDir.mkdirs();
                try {
                    ArchiveUtils.unpackToWorkDir(war, workDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return module;
            }
        }
        return null;
    }
}

