/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;

public class WebAppModuleFromIDEGAVStrategy
extends AbstractModuleDiscoveryStrategy {
    private final String groupId;
    private final String artifactId;
    private final boolean useIdeSourcePath;

    public WebAppModuleFromIDEGAVStrategy(String groupId, String artifactId, boolean useIdeSourcePath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.useIdeSourcePath = useIdeSourcePath;
    }

    @Override
    public String getName() {
        return "IDE";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        URLClassLoader urlCL = (URLClassLoader)this.getClass().getClassLoader();
        TreeSet<URL> sortedURLs = new TreeSet<URL>(new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.toExternalForm().compareTo(o2.toExternalForm());
            }
        });
        sortedURLs.addAll(Arrays.asList(urlCL.getURLs()));
        String moduleUrl = null;
        for (URL url : sortedURLs) {
            String urlstr = url.toExternalForm();
            if (!urlstr.contains("/" + this.artifactId + "/target")) continue;
            moduleUrl = urlstr;
            break;
        }
        if (moduleUrl == null) {
            return null;
        }
        this.debug("Module URL: " + moduleUrl);
        try {
            String pathToWebApp = null;
            String replacementPath = "/target/" + this.artifactId;
            if (this.useIdeSourcePath) {
                replacementPath = "/src/main/webapp";
            }
            if (moduleUrl.contains("/target/classes")) {
                pathToWebApp = moduleUrl.replace("/target/classes", replacementPath);
            } else if (moduleUrl.contains("/target/" + this.artifactId + "/WEB-INF/classes")) {
                pathToWebApp = moduleUrl.replace("/target/" + this.artifactId + "/WEB-INF/classes", replacementPath);
            }
            if (pathToWebApp != null) {
                this.debug("Path to web app: " + pathToWebApp);
                File webApp = new File(new URL(pathToWebApp).toURI());
                if (webApp.exists()) {
                    DevServerModule module = new DevServerModule();
                    module.setInIDE(true);
                    module.setModuleDir(webApp);
                    return module;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

