/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands;

import java.io.File;
import org.apache.felix.gogo.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.overlord.commons.karaf.commands.i18n.Messages;
import org.overlord.commons.karaf.commands.saml.GenerateSamlKeystoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlKeystoreCommand
extends OsgiCommandSupport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSamlKeystoreCommand.class);
    @Argument(index=0, name="keystorePassword", required=true, multiValued=false)
    protected String keystorePassword = null;

    protected Object doExecute() throws Exception {
        String fuse_config_path = this.getConfigPath();
        String file = fuse_config_path + "overlord-saml.keystore";
        File keystore = new File(file);
        logger.info(Messages.getString("generate.saml.keystore.command.correctly.begin"));
        GenerateSamlKeystoreUtil util = new GenerateSamlKeystoreUtil();
        util.generate(this.keystorePassword, keystore);
        this.updateOverlordProperties();
        logger.info(Messages.getString("generate.saml.keystore.command.correctly.created"));
        return null;
    }

    protected abstract String getConfigPath();

    protected abstract void updateOverlordProperties() throws Exception;

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }
}

