/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands.configure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.overlord.commons.karaf.commands.ChangePasswordCommand;
import org.overlord.commons.karaf.commands.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractConfigureCommand
extends OsgiCommandSupport {
    protected String karafHome = System.getProperty("karaf.home");
    protected String karafConfigDir = "etc";
    protected String karafConfigPath;
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigureCommand.class);
    @Argument(index=0, name="password", required=false, multiValued=false)
    protected String password = null;

    public AbstractConfigureCommand() {
        StringBuilder sb = new StringBuilder(this.karafHome);
        if (!this.karafHome.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(this.karafConfigDir).append(File.separator);
        this.karafConfigPath = sb.toString();
    }

    protected Object doExecute() throws Exception {
        File destFile = new File(this.karafConfigPath + "overlord.properties");
        logger.info(Messages.getString("overlord.configure.execution"));
        if (destFile.exists()) {
            String message = Messages.getString("overlord.configure.password.previous.installation");
            System.out.println(message);
            logger.info(message);
            return null;
        }
        if (StringUtils.isBlank((String)this.password)) {
            throw new RuntimeException(Messages.getString("overlord.configure.password.required.first.install"));
        }
        logger.debug(Messages.getString("overlord.configure.execution.started"));
        this.commonActions();
        ChangePasswordCommand passwordCommand = new ChangePasswordCommand();
        passwordCommand.setCreationAllowed(true);
        passwordCommand.setBundleContext(this.bundleContext);
        passwordCommand.setPassword(this.password);
        passwordCommand.execute(this.session);
        logger.debug(Messages.getString("overlord.configure.execution.ended"));
        return null;
    }

    public void commonActions() throws Exception {
        logger.debug(Messages.getString("overlord.configure.common.actions.started"));
        File xmlFile = new File(this.karafConfigPath + "jetty.xml");
        InputStream xsltFile = AbstractConfigureCommand.class.getClassLoader().getResourceAsStream("/addRealm-fuse-6.1.xslt");
        this.applyXslt(xmlFile, xsltFile);
        Properties jaasProperties = new Properties();
        File srcFile = new File(this.karafConfigPath + "org.apache.karaf.jaas.cfg");
        jaasProperties.load(new FileInputStream(srcFile));
        jaasProperties.setProperty("encryption.enabled", "true");
        jaasProperties.setProperty("encryption.algorithm", "SHA-256");
        jaasProperties.store(new FileOutputStream(srcFile), "");
        Properties mvnProperties = new Properties();
        srcFile = new File(this.karafConfigPath + "org.ops4j.pax.url.mvn.cfg");
        mvnProperties.load(new FileInputStream(srcFile));
        mvnProperties.setProperty("org.ops4j.pax.url.mvn.repositories", mvnProperties.getProperty("org.ops4j.pax.url.mvn.repositories") + ", http://repository.jboss.org/nexus/content/groups/developer/@snapshots");
        mvnProperties.store(new FileOutputStream(srcFile), "");
        logger.debug(Messages.getString("overlord.configure.common.actions.started"));
    }

    protected void applyXslt(File xmlFile, InputStream xsltFile) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String pid, String sid) throws SAXException {
                return new InputSource(AbstractConfigureCommand.class.getClassLoader().getResourceAsStream("xslt/configure.dtd"));
            }
        });
        Document d = db.parse(xmlFile);
        DOMSource xml = new DOMSource(d);
        StreamSource xslt = new StreamSource(xsltFile);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(xslt);
        StreamResult result = new StreamResult(xmlFile);
        transformer.transform(xml, result);
    }

    protected void copyFile(String filename) throws Exception {
        File destFile = new File(this.karafConfigPath + filename);
        if (!destFile.exists()) {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + filename);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)destFile);
        }
    }

    protected void copyFile(String inputFile, String destFileName) throws Exception {
        File destFile = new File(this.karafConfigPath + destFileName);
        if (!destFile.exists()) {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + inputFile);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)destFile);
        }
    }
}

