/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.karaf.commands.AbstractSamlKeystoreCommand;

@Command(scope="overlord", name="generateSamlKeystore")
public class GenerateSamlKeystoreCommand
extends AbstractSamlKeystoreCommand {
    private static final String FUSE_CONFIG_DIR = "etc";

    @Override
    protected String getConfigPath() {
        String karaf_home = System.getProperty("karaf.home");
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(karaf_home);
        if (!karaf_home.endsWith(File.separator)) {
            fuse_config_path.append(File.separator);
        }
        fuse_config_path.append(FUSE_CONFIG_DIR).append(File.separator);
        return fuse_config_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateOverlordProperties() throws Exception {
        block11: {
            String filePath = this.getOverlordPropertiesFilePath();
            File overlordFile = new File(filePath);
            if (overlordFile.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(filePath);
                    Properties props = new Properties();
                    props.load(in);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(filePath);
                        props.setProperty("overlord.auth.saml-key-alias-password", this.password);
                        props.setProperty("overlord.auth.saml-keystore-password", this.password);
                        props.store(out, null);
                        break block11;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            boolean created = overlordFile.createNewFile();
            if (created) {
                Properties props = new Properties();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(filePath);
                    props.setProperty("overlord.auth.saml-keystore", "${sys:karaf.home}/etc/overlord-saml.keystore");
                    props.setProperty("overlord.auth.saml-key-alias", "overlord");
                    props.setProperty("overlord.auth.saml-key-alias-password", this.password);
                    props.setProperty("overlord.auth.saml-keystore-password", this.password);
                    props.store(out, null);
                }
                finally {
                    out.close();
                }
            }
        }
    }

    private String getOverlordPropertiesFilePath() {
        String karaf_home = System.getProperty("karaf.home");
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(karaf_home);
        if (!karaf_home.endsWith(File.separator)) {
            fuse_config_path.append(File.separator);
        }
        fuse_config_path.append(FUSE_CONFIG_DIR).append(File.separator).append("overlord.properties");
        return fuse_config_path.toString();
    }
}

