/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.maven.plugin.featuresxml;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeaturesXml {
    private static final String FEATURES_XML_NS = "http://karaf.apache.org/xmlns/features/v1.0.0";
    private Document document;
    private Element rootElement;
    private Map<String, Element> features = new HashMap<String, Element>();

    public FeaturesXml() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setValidating(false);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.document = docBuilder.newDocument();
        this.rootElement = this.document.createElementNS(FEATURES_XML_NS, "features");
        this.document.appendChild(this.rootElement);
    }

    public void addRepository(String repo) {
        Element repoElem = this.document.createElementNS(FEATURES_XML_NS, "repository");
        this.rootElement.appendChild(repoElem);
        repoElem.setTextContent(repo);
    }

    public void addFeature(String name, String version, String comment) {
        if (comment != null) {
            Comment commentNode = this.document.createComment(" " + comment + " ");
            this.rootElement.appendChild(commentNode);
        }
        Element featureElem = this.document.createElementNS(FEATURES_XML_NS, "feature");
        this.rootElement.appendChild(featureElem);
        featureElem.setAttribute("name", name);
        featureElem.setAttribute("version", version);
        String featureKey = name + "||" + version;
        this.features.put(featureKey, featureElem);
    }

    public void addFeatureDependency(String name, String version, String dependencyName, String dependencyVersion) {
        String featureKey = name + "||" + version;
        Element featureElem = this.features.get(featureKey);
        if (featureElem != null) {
            Element dependencyElem = this.document.createElementNS(FEATURES_XML_NS, "feature");
            featureElem.appendChild(dependencyElem);
            dependencyElem.setTextContent(dependencyName);
            if (dependencyVersion != null) {
                dependencyElem.setAttribute("version", dependencyVersion);
            }
        }
    }

    public void addBundle(String name, String version, String bundle, String startLevel) {
        String featureKey = name + "||" + version;
        Element featureElem = this.features.get(featureKey);
        if (featureElem != null) {
            Element bundleElem = this.document.createElementNS(FEATURES_XML_NS, "bundle");
            featureElem.appendChild(bundleElem);
            bundleElem.setTextContent(bundle);
            if (startLevel != null && !startLevel.trim().isEmpty()) {
                bundleElem.setAttribute("start-level", startLevel);
            }
        }
    }

    public void addConfigFile(String name, String version, String finalName, String value) {
        String featureKey = name + "||" + version;
        Element featureElem = this.features.get(featureKey);
        if (featureElem != null) {
            Element configFileElem = this.document.createElementNS(FEATURES_XML_NS, "configfile");
            featureElem.appendChild(configFileElem);
            configFileElem.setTextContent(value);
            configFileElem.setAttribute("finalname", finalName);
        }
    }

    public void writeTo(File outputFile) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 3);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(outputFile);
        transformer.transform(source, result);
    }
}

