/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.osgi.weld;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.osgi.vfs.IVfsBundleFactory;
import org.overlord.commons.osgi.vfs.VfsBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleURLScanner
extends URLScanner {
    private static final Logger log = LoggerFactory.getLogger(BundleURLScanner.class);
    private static final int MAXIMUM_TRIES = 10;
    private static final int MILLISECONDS_WAIT = 500;

    public BundleURLScanner(ClassLoader classLoader, ServletContext context) {
        super(classLoader);
    }

    protected void handleURL(URL url, Set<String> classes, Set<URL> urls) {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference serviceReference = null;
        int tries = 0;
        do {
            if ((serviceReference = bundleContext.getServiceReference(IVfsBundleFactory.class.getName())) != null) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (serviceReference == null && tries < 10);
        if (serviceReference == null) {
            throw new RuntimeException("Failed to find OSGi service [IVfsBundleFactory].");
        }
        IVfsBundleFactory factory = (IVfsBundleFactory)bundleContext.getService(serviceReference);
        VfsBundle vfsBundle = factory.getVfsBundle(url);
        File file = vfsBundle.asFile(url);
        HashSet<String> paths = new HashSet<String>();
        if (file.isDirectory()) {
            File webClasses = new File(file, "WEB-INF/classes");
            if (webClasses.exists()) {
                paths.add(webClasses.getAbsolutePath());
            }
        } else {
            paths.add(file.getAbsolutePath());
        }
        this.handle(paths, classes, urls);
    }

    public void scanResources(String[] resources, Set<String> classes, Set<URL> urls) {
        for (String resourceName : resources) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(BundleURLScanner.class);
                Enumeration urlEnum = bundle.getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = (URL)urlEnum.nextElement();
                    this.handleURL(url, classes, urls);
                }
            }
            catch (IOException ioe) {
                log.warn("could not read: " + resourceName, (Throwable)ioe);
            }
        }
    }
}

