/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.osgi.vfs;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.overlord.commons.osgi.vfs.IVfsBundleFactory;
import org.overlord.commons.osgi.vfs.VfsBundle;

public class VfsBundleFactory
implements IVfsBundleFactory {
    private final Map<Long, VfsBundle> vfsBundleCache = new HashMap<Long, VfsBundle>();

    @Override
    public synchronized VfsBundle getVfsBundle(URL url) {
        String host = url.getHost();
        long bundleId = Long.valueOf(host.split("\\.")[0]);
        Bundle[] bundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().getBundles();
        Bundle theBundle = null;
        for (Bundle bundle : bundles) {
            if (bundle.getBundleId() != bundleId) continue;
            theBundle = bundle;
            break;
        }
        if (theBundle == null) {
            throw new RuntimeException("Unable to find bundle for URL: " + url);
        }
        VfsBundle vfsBundle = this.vfsBundleCache.get(bundleId);
        if (vfsBundle == null) {
            vfsBundle = new VfsBundle(theBundle);
            this.vfsBundleCache.put(bundleId, vfsBundle);
        }
        return vfsBundle;
    }
}

