/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.commons.services.ServiceClose;
import org.overlord.commons.services.ServiceInit;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistry;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private static final Logger LOG = Logger.getLogger(AbstractServiceRegistry.class.getName());

    @Override
    public <T> void addServiceListener(Class<T> serviceInterface, ServiceListener<T> listener) {
        Set<T> services = this.getServices(serviceInterface);
        if (services != null) {
            for (T service : services) {
                listener.registered(service);
            }
        }
    }

    @Override
    public <T> void removeServiceListener(ServiceListener<T> listener) {
    }

    protected void init(Object service) {
        if (service != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Service created by [" + this.getClass().getSimpleName() + "] is: " + service);
            }
            Method[] methods = service.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(ServiceInit.class) || methods[i].getReturnType() != Void.TYPE || methods[i].getParameterTypes().length != 0) continue;
                try {
                    methods[i].invoke(service, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    protected void close(Object service) {
        if (service != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Service closed by [" + this.getClass().getSimpleName() + "] is: " + service);
            }
            Method[] methods = service.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(ServiceClose.class) || methods[i].getReturnType() != Void.TYPE || methods[i].getParameterTypes().length != 0) continue;
                try {
                    methods[i].invoke(service, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

