/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.acs.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.active.collection.AbstractACSLoader;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.util.ActiveCollectionUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEACSLoader
extends AbstractACSLoader {
    private static final Logger LOG = Logger.getLogger(JEEACSLoader.class.getName());
    private static final String ACS_JSON = "acs.json";
    private List<ActiveCollectionSource> _activeCollectionSources = null;
    private ServiceListener<ActiveCollectionManager> _listener;

    @PostConstruct
    public void init() {
        this._listener = new ServiceListener<ActiveCollectionManager>(){

            public void registered(ActiveCollectionManager service) {
                JEEACSLoader.this.registerActiveCollectionSource(service);
            }

            public void unregistered(ActiveCollectionManager service) {
                JEEACSLoader.this.unregisterActiveCollectionSource(service);
            }
        };
        ServiceRegistryUtil.addServiceListener(ActiveCollectionManager.class, this._listener);
    }

    protected void registerActiveCollectionSource(ActiveCollectionManager acmManager) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register ActiveCollectionSource");
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(ACS_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activeCollectionSources = ActiveCollectionUtil.deserializeACS((byte[])b);
                if (this._activeCollectionSources == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-2"));
                } else {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this.preInit(acs);
                        acmManager.register(acs);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-3"), e);
        }
    }

    protected void unregisterActiveCollectionSource(ActiveCollectionManager acmManager) {
        block5: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unregister ActiveCollectionSource");
            }
            if (acmManager != null && this._activeCollectionSources != null) {
                try {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        acmManager.unregister(acs);
                    }
                    this._activeCollectionSources = null;
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINER)) break block5;
                    LOG.log(Level.FINER, PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-4"), t);
                }
            }
        }
    }

    @PreDestroy
    public void close() {
        ActiveCollectionManager acManager;
        if (this._activeCollectionSources != null && (acManager = (ActiveCollectionManager)ServiceRegistryUtil.getSingleService(ActiveCollectionManager.class)) != null) {
            this.unregisterActiveCollectionSource(acManager);
        }
        ServiceRegistryUtil.removeServiceListener(this._listener);
        this._listener = null;
    }
}

