/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.call.trace.descriptors;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.app.LogMessage;
import org.overlord.rtgov.call.trace.descriptors.TaskDescriptor;
import org.overlord.rtgov.call.trace.util.CallTraceUtil;

public class DefaultTaskDescriptor
implements TaskDescriptor {
    private static final Logger LOG = Logger.getLogger(DefaultTaskDescriptor.class.getName());

    @Override
    public boolean isSupported(ActivityType at) {
        return at instanceof LogMessage;
    }

    @Override
    public String getDescription(ActivityType at) {
        StringBuffer buf = new StringBuffer();
        buf.append(at.getClass().getSimpleName());
        try {
            BeanInfo bi = Introspector.getBeanInfo(at.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!CallTraceUtil.shouldIncludeProperty(pd)) continue;
                try {
                    Object value = pd.getReadMethod().invoke((Object)at, new Object[0]);
                    if (value == null) continue;
                    buf.append(" " + pd.getDisplayName());
                    buf.append("=" + value);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("call-trace.Messages").getString("CALL-TRACE-3"), at.getClass().getName(), pd.getName()), ex);
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("call-trace.Messages").getString("CALL-TRACE-2"), at.getClass().getName()), e);
        }
        return buf.toString();
    }
}

