/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.service.dependency.svg;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.overlord.rtgov.analytics.service.InvocationDefinition;
import org.overlord.rtgov.analytics.service.InvocationMetric;
import org.overlord.rtgov.analytics.situation.Situation;
import org.overlord.rtgov.service.dependency.InvocationLink;
import org.overlord.rtgov.service.dependency.OperationNode;
import org.overlord.rtgov.service.dependency.ServiceDependencyBuilder;
import org.overlord.rtgov.service.dependency.ServiceGraph;
import org.overlord.rtgov.service.dependency.ServiceNode;
import org.overlord.rtgov.service.dependency.UsageLink;
import org.overlord.rtgov.service.dependency.presentation.Severity;
import org.overlord.rtgov.service.dependency.presentation.SeverityAnalyzer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SVGServiceGraphGenerator {
    private static final Logger LOG = Logger.getLogger(SVGServiceGraphGenerator.class.getName());
    private SeverityAnalyzer _severityAnalyzer = null;
    private static String[] _colorCodes = new String[]{"#00FF00", "#FF9900", "#FF6A45", "#FF5930", "#FF3300", "#FF0000"};

    public SeverityAnalyzer getSeverityAnalyzer() {
        return this._severityAnalyzer;
    }

    public void setSeverityAnalyzer(SeverityAnalyzer analyzer) {
        this._severityAnalyzer = analyzer;
    }

    public void generate(ServiceGraph sg, int maxWidth, OutputStream os) throws Exception {
        Document doc;
        double ratio = 1.0;
        if (maxWidth > 0) {
            int width = (Integer)sg.getProperties().get("Width");
            ratio = (double)maxWidth / (double)width;
        }
        if ((doc = this.loadTemplate(ratio < 0.8 ? "summary" : "main")) != null) {
            Text textValue;
            Element text;
            Element container = doc.getDocumentElement();
            Node insertPoint = null;
            NodeList nl = container.getElementsByTagName("insert");
            if (nl.getLength() == 1) {
                insertPoint = nl.item(0);
            }
            if (sg.getDescription() != null && ratio >= 1.0) {
                text = container.getOwnerDocument().createElement("text");
                text.setAttribute("x", "10");
                text.setAttribute("y", "20");
                text.setAttribute("font-size", "14");
                text.setAttribute("font-family", "Verdana");
                text.setAttribute("fill", "black");
                container.insertBefore(text, insertPoint);
                textValue = container.getOwnerDocument().createTextNode(sg.getDescription());
                text.appendChild(textValue);
            }
            if (sg.getServiceNodes().size() > 0) {
                for (ServiceNode sn : sg.getServiceNodes()) {
                    this.generateService(sn, ratio, container, insertPoint);
                }
                for (UsageLink ul : sg.getUsageLinks()) {
                    this.generateUsageLink(ul, ratio, container, insertPoint);
                }
                for (InvocationLink il : sg.getInvocationLinks()) {
                    this.generateInvocationLink(il, ratio, container, insertPoint);
                }
            } else {
                text = container.getOwnerDocument().createElement("text");
                text.setAttribute("x", "50");
                text.setAttribute("y", "100");
                text.setAttribute("font-size", "30");
                text.setAttribute("font-family", "Verdana");
                text.setAttribute("fill", "#D9D9C2");
                container.insertBefore(text, insertPoint);
                textValue = container.getOwnerDocument().createTextNode("No Service Activity");
                text.appendChild(textValue);
            }
            if (insertPoint != null) {
                container.removeChild(insertPoint);
            }
            this.saveDocument(doc, os);
        }
    }

    protected void generateUsageLink(UsageLink ul, double ratio, Element container, Node insertPoint) {
        if (!ul.getSource().getProperties().containsKey("Width")) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("Source node on usage link with definition '" + ul.getSource().getService() + "' does not have layout information");
            }
            return;
        }
        if (!ul.getTarget().getProperties().containsKey("Width")) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("Target node on usage link with definition '" + ul.getTarget().getService() + "' does not have layout information");
            }
            return;
        }
        int x1 = (int)((double)((Integer)ul.getSource().getProperties().get("XPosition") + (Integer)ul.getSource().getProperties().get("Width")) * ratio);
        int y1 = (int)((double)((Integer)ul.getSource().getProperties().get("YPosition")).intValue() * ratio);
        int x2 = (int)((double)((Integer)ul.getTarget().getProperties().get("XPosition")).intValue() * ratio);
        int y2 = (int)((double)((Integer)ul.getTarget().getProperties().get("YPosition")).intValue() * ratio);
        int x3 = (int)((double)((Integer)ul.getTarget().getProperties().get("XPosition")).intValue() * ratio);
        int y3 = (int)((double)((Integer)ul.getTarget().getProperties().get("YPosition") + (Integer)ul.getTarget().getProperties().get("Height")) * ratio);
        int x4 = (int)((double)((Integer)ul.getSource().getProperties().get("XPosition") + (Integer)ul.getSource().getProperties().get("Width")) * ratio);
        int y4 = (int)((double)((Integer)ul.getSource().getProperties().get("YPosition") + (Integer)ul.getSource().getProperties().get("Height")) * ratio);
        Element polygon = container.getOwnerDocument().createElement("polygon");
        polygon.setAttribute("points", x1 + "," + y1 + " " + x2 + "," + y2 + " " + x3 + "," + y3 + " " + x4 + "," + y4);
        Severity severity = this.getInvocationSeverity(ul.getInvocations());
        String color = this.getColor(severity);
        polygon.setAttribute("style", "fill:" + color + ";fill-opacity:0.2");
        container.insertBefore(polygon, insertPoint);
        if (ratio >= 1.0) {
            this.generateMetrics(polygon, this.getDescription(ul), ServiceDependencyBuilder.getMergedMetrics((List)ul.getInvocations()));
        }
    }

    protected String getDescription(UsageLink ul) {
        return ul.getSource().getService().getServiceType() + " -> " + ul.getTarget().getService().getServiceType();
    }

    protected String getColor(Severity severity) {
        if (severity == null) {
            return _colorCodes[0];
        }
        return _colorCodes[severity.ordinal()];
    }

    protected void generateInvocationLink(InvocationLink il, double ratio, Element container, Node insertPoint) {
        if (!il.getSource().getProperties().containsKey("Width")) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("Source node on invocation link with definition '" + il.getSource().getService() + "' does not have layout information");
            }
            return;
        }
        if (!il.getTarget().getProperties().containsKey("Width")) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("Target node on invocation link with definition '" + il.getTarget().getService() + "' does not have layout information");
            }
            return;
        }
        int x1 = (int)((double)((Integer)il.getSource().getProperties().get("XPosition") + (Integer)il.getSource().getProperties().get("Width")) * ratio);
        int y1 = (int)((double)((Integer)il.getSource().getProperties().get("YPosition") + (Integer)il.getSource().getProperties().get("Height") / 2) * ratio);
        int x2 = (int)((double)((Integer)il.getTarget().getProperties().get("XPosition")).intValue() * ratio);
        int y2 = (int)((double)((Integer)il.getTarget().getProperties().get("YPosition") + (Integer)il.getTarget().getProperties().get("Height") / 2) * ratio);
        Element line = container.getOwnerDocument().createElement("line");
        line.setAttribute("x1", "" + x1);
        line.setAttribute("y1", "" + y1);
        line.setAttribute("x2", "" + x2);
        line.setAttribute("y2", "" + y2);
        Severity severity = this.getInvocationSeverity(il.getInvocations());
        String color = this.getColor(severity);
        line.setAttribute("style", "stroke:" + color + ";stroke-width:3");
        container.insertBefore(line, insertPoint);
        if (ratio >= 1.0) {
            this.generateMetrics(line, this.getDescription(il), ServiceDependencyBuilder.getMergedMetrics((List)il.getInvocations()));
        }
    }

    protected String getDescription(InvocationLink il) {
        return il.getTarget().getService().getServiceType() + " -> " + il.getTarget().getOperation().getName();
    }

    protected void generateService(ServiceNode sn, double ratio, Element container, Node insertPoint) {
        if (!sn.getProperties().containsKey("Width")) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("Service node with definition '" + sn.getService() + "' does not have layout information");
            }
            return;
        }
        Element rect = container.getOwnerDocument().createElement("rect");
        int width = (int)((double)((Integer)sn.getProperties().get("Width")).intValue() * ratio);
        rect.setAttribute("width", "" + width);
        int height = (int)((double)((Integer)sn.getProperties().get("Height")).intValue() * ratio);
        rect.setAttribute("height", "" + height);
        int x = (int)((double)((Integer)sn.getProperties().get("XPosition")).intValue() * ratio);
        rect.setAttribute("x", "" + x);
        int y = (int)((double)((Integer)sn.getProperties().get("YPosition")).intValue() * ratio);
        rect.setAttribute("y", "" + y);
        rect.setAttribute("fill", "#B8DBFF");
        Severity severity = null;
        if (this.getSeverityAnalyzer() != null) {
            severity = this.getSeverityAnalyzer().getSeverity((Object)sn, sn.getService().getMetrics(), sn.getService().getHistory());
        }
        String color = this.getColor(severity);
        rect.setAttribute("stroke", color);
        rect.setAttribute("stroke-width", "2");
        rect.setAttribute("filter", "url(#f1)");
        container.insertBefore(rect, insertPoint);
        x = (Integer)sn.getProperties().get("XPosition");
        x += 5;
        x = (int)((double)x * ratio);
        y = (Integer)sn.getProperties().get("YPosition");
        y += 10;
        y = (int)((double)y * ratio);
        if (this.isGenerateToolTips(ratio)) {
            this.generateMetrics(rect, sn.getService().getServiceType(), sn.getService().getMetrics());
        }
        Element text = container.getOwnerDocument().createElement("text");
        text.setAttribute("x", "" + x);
        text.setAttribute("y", "" + y);
        text.setAttribute("font-family", "Verdana");
        text.setAttribute("font-size", "10");
        text.setAttribute("fill", "#00008F");
        String localname = this.getLocalName(sn.getService().getServiceType());
        Text value = container.getOwnerDocument().createTextNode(localname);
        text.appendChild(value);
        container.insertBefore(text, insertPoint);
        if (sn.getSituations().size() > 0) {
            this.generateSituations(container, insertPoint, x + (int)((double)width * 0.9), y, ratio, sn.getSituations());
        }
        for (OperationNode opn : sn.getOperations()) {
            this.generateOperation(opn, ratio, container, insertPoint);
        }
    }

    protected String getLocalName(String qname) {
        String ret = qname;
        if (qname.length() > 0) {
            if (qname.charAt(0) == '{') {
                ret = QName.valueOf(qname).getLocalPart();
            } else {
                int pos = qname.lastIndexOf(46);
                if (pos != -1) {
                    ret = qname.substring(pos + 1);
                }
            }
        }
        return ret;
    }

    protected boolean isGenerateToolTips(double ratio) {
        return ratio >= 1.0;
    }

    protected boolean isGenerateText(double ratio) {
        return ratio >= 1.0;
    }

    protected void generateSituations(Element container, Node insertPoint, int x, int y, double ratio, List<Situation> situations) {
        int radius = (int)(6.0 * ratio);
        Element circle = container.getOwnerDocument().createElement("circle");
        circle.setAttribute("cx", "" + x);
        circle.setAttribute("cy", "" + y);
        circle.setAttribute("r", "" + radius);
        container.insertBefore(circle, insertPoint);
        Situation.Severity severity = Situation.getHighestSeverity(situations);
        if (severity != null) {
            String color = this.getSituationSeverityColor(severity);
            circle.setAttribute("fill", color);
        }
        if (this.isGenerateToolTips(ratio)) {
            List low;
            List medium;
            List high;
            Element title = container.getOwnerDocument().createElement("desc");
            circle.appendChild(title);
            Text titleText = container.getOwnerDocument().createTextNode("Situations");
            title.appendChild(titleText);
            List critical = Situation.getSituationsForSeverity((Situation.Severity)Situation.Severity.Critical, situations);
            if (critical.size() > 0) {
                Element desc = container.getOwnerDocument().createElement(Situation.Severity.Critical.name());
                circle.appendChild(desc);
                Text descText = container.getOwnerDocument().createTextNode(this.getSituationText((Situation)critical.get(0)));
                desc.appendChild(descText);
            }
            if ((high = Situation.getSituationsForSeverity((Situation.Severity)Situation.Severity.High, situations)).size() > 0) {
                Element desc = container.getOwnerDocument().createElement(Situation.Severity.High.name());
                circle.appendChild(desc);
                Text descText = container.getOwnerDocument().createTextNode(this.getSituationText((Situation)high.get(0)));
                desc.appendChild(descText);
            }
            if ((medium = Situation.getSituationsForSeverity((Situation.Severity)Situation.Severity.Medium, situations)).size() > 0) {
                Element desc = container.getOwnerDocument().createElement(Situation.Severity.Medium.name());
                circle.appendChild(desc);
                Text descText = container.getOwnerDocument().createTextNode(this.getSituationText((Situation)medium.get(0)));
                desc.appendChild(descText);
            }
            if ((low = Situation.getSituationsForSeverity((Situation.Severity)Situation.Severity.Low, situations)).size() > 0) {
                Element desc = container.getOwnerDocument().createElement(Situation.Severity.Low.name());
                circle.appendChild(desc);
                Text descText = container.getOwnerDocument().createTextNode(this.getSituationText((Situation)low.get(0)));
                desc.appendChild(descText);
            }
        }
    }

    protected String getSituationText(Situation s) {
        return s.getType() + ": " + s.getDescription() + " [" + new Date(s.getTimestamp()) + "]";
    }

    protected String getSituationSeverityColor(Situation.Severity severity) {
        String ret = null;
        ret = severity == Situation.Severity.Critical ? "red" : (severity == Situation.Severity.High ? "orange" : (severity == Situation.Severity.Medium ? "yellow" : "green"));
        return ret;
    }

    protected Severity getInvocationSeverity(List<InvocationDefinition> invocations) {
        if (this.getSeverityAnalyzer() == null) {
            return Severity.Normal;
        }
        Severity[] severities = new Severity[invocations.size()];
        for (int i = 0; i < invocations.size(); ++i) {
            InvocationDefinition id = invocations.get(i);
            severities[i] = this.getSeverityAnalyzer().getSeverity((Object)id, id.getMetrics(), id.getHistory());
        }
        return SVGServiceGraphGenerator.getAverageSeverity(severities);
    }

    protected static Severity getAverageSeverity(Severity[] severities) {
        Severity ret = Severity.Normal;
        int sum = 0;
        for (Severity s : severities) {
            sum = s.ordinal();
        }
        if (sum > 0) {
            float result = sum / severities.length;
            ret = Severity.values()[Math.round(result)];
        }
        return ret;
    }

    protected void generateMetrics(Element container, String description, InvocationMetric metrics) {
        Element desc = container.getOwnerDocument().createElement("desc");
        container.appendChild(desc);
        Text descText = container.getOwnerDocument().createTextNode(description);
        desc.appendChild(descText);
        String countValue = "Count " + metrics.getCount();
        String avgValue = "Avg " + metrics.getAverage();
        String minValue = "Min " + metrics.getMin();
        String maxValue = "Max " + metrics.getMax();
        if (metrics.getFaults() > 0) {
            countValue = countValue + " [faults " + metrics.getFaults() + "]";
        }
        if (metrics.getAverageChange() != 0 || metrics.getMaxChange() != 0 || metrics.getMinChange() != 0 || metrics.getCountChange() != 0) {
            countValue = countValue + " (" + metrics.getCountChange() + "%)";
            avgValue = avgValue + " (" + metrics.getAverageChange() + "%)";
            minValue = minValue + " (" + metrics.getMinChange() + "%)";
            maxValue = maxValue + " (" + metrics.getMaxChange() + "%)";
        }
        Element count = container.getOwnerDocument().createElement("count");
        container.appendChild(count);
        Text countText = container.getOwnerDocument().createTextNode(countValue);
        count.appendChild(countText);
        Element avg = container.getOwnerDocument().createElement("avg");
        container.appendChild(avg);
        Text avgText = container.getOwnerDocument().createTextNode(avgValue);
        avg.appendChild(avgText);
        Element max = container.getOwnerDocument().createElement("max");
        container.appendChild(max);
        Text maxText = container.getOwnerDocument().createTextNode(maxValue);
        max.appendChild(maxText);
        Element min = container.getOwnerDocument().createElement("min");
        container.appendChild(min);
        Text minText = container.getOwnerDocument().createTextNode(minValue);
        min.appendChild(minText);
    }

    protected void generateOperation(OperationNode opn, double ratio, Element container, Node insertPoint) {
        Element rect = container.getOwnerDocument().createElement("rect");
        int width = (int)((double)((Integer)opn.getProperties().get("Width")).intValue() * ratio);
        rect.setAttribute("width", "" + width);
        int height = (int)((double)((Integer)opn.getProperties().get("Height")).intValue() * ratio);
        rect.setAttribute("height", "" + height);
        int x = (int)((double)((Integer)opn.getProperties().get("XPosition")).intValue() * ratio);
        rect.setAttribute("x", "" + x);
        int y = (int)((double)((Integer)opn.getProperties().get("YPosition")).intValue() * ratio);
        rect.setAttribute("y", "" + y);
        rect.setAttribute("fill", "#85D6FF");
        Severity severity = null;
        if (this.getSeverityAnalyzer() != null) {
            severity = this.getSeverityAnalyzer().getSeverity((Object)opn, opn.getOperation().getMetrics(), opn.getOperation().getHistory());
        }
        String color = this.getColor(severity);
        rect.setAttribute("stroke", color);
        rect.setAttribute("stroke-width", "1");
        container.insertBefore(rect, insertPoint);
        x = (Integer)opn.getProperties().get("XPosition");
        x += 5;
        x = (int)((double)x * ratio);
        y = (Integer)opn.getProperties().get("YPosition");
        y += 14;
        y = (int)((double)y * ratio);
        if (this.isGenerateText(ratio)) {
            Element text = container.getOwnerDocument().createElement("text");
            text.setAttribute("x", "" + x);
            text.setAttribute("y", "" + y);
            text.setAttribute("font-family", "Verdana");
            text.setAttribute("font-size", "12");
            text.setAttribute("fill", "#00008F");
            Text value = container.getOwnerDocument().createTextNode(opn.getOperation().getName());
            text.appendChild(value);
            container.insertBefore(text, insertPoint);
        }
        if (this.isGenerateToolTips(ratio)) {
            this.generateMetrics(rect, opn.getOperation().getName(), opn.getOperation().getMetrics());
        }
        if (opn.getSituations().size() > 0) {
            this.generateSituations(container, insertPoint, x + (int)((double)width * 0.9), y - 4, ratio, opn.getSituations());
        }
    }

    protected void saveDocument(Document doc, OutputStream os) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(os));
    }

    protected Document loadTemplate(String name) {
        Document ret = null;
        try {
            String template = "templates/" + name + ".svg";
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + template);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ret = builder.parse(is);
            is.close();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("service-dependency-svg.Messages").getString("SERVICE-DEPENDENCY-SVG-1"), name), e);
        }
        return ret;
    }
}

