/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.server.impl;

import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.server.ActivityNotifier;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.activity.server.ActivityStore;
import org.overlord.rtgov.activity.server.QuerySpec;
import org.overlord.rtgov.activity.server.impl.Transactional;

@Singleton
@Transactional
public class ActivityServerImpl
implements ActivityServer {
    @Inject
    private ActivityStore _store = null;
    private List<ActivityNotifier> _notifiers = new Vector<ActivityNotifier>();
    @Inject
    @Any
    private Instance<ActivityNotifier> _injectedNotifiers = null;

    public void setActivityStore(ActivityStore store) {
        this._store = store;
    }

    public ActivityStore getActivityStore() {
        return this._store;
    }

    public List<ActivityNotifier> getActivityNotifiers() {
        return this._notifiers;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void store(List<ActivityUnit> activities) throws Exception {
        for (ActivityUnit au : activities) {
            this.processActivityUnit(au);
        }
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        this._store.store(activities);
        for (ActivityNotifier notifier : this._notifiers) {
            notifier.notify(activities);
        }
        if (this._injectedNotifiers != null) {
            for (ActivityNotifier notifier : this._injectedNotifiers) {
                notifier.notify(activities);
            }
        }
    }

    protected void processActivityUnit(ActivityUnit au) {
        if (au.getId() == null) {
            au.setId(this.createUniqueId());
        }
        au.init();
    }

    protected String createUniqueId() {
        return UUID.randomUUID().toString();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public ActivityUnit getActivityUnit(String id) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.getActivityUnit(id);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<ActivityType> query(QuerySpec query) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.query(query);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<ActivityType> getActivityTypes(Context context) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.getActivityTypes(context);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<ActivityType> getActivityTypes(Context context, long from, long to) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.getActivityTypes(context, from, to);
    }
}

