/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.server.rest.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.activity.server.QuerySpec;
import org.overlord.rtgov.activity.util.ActivityUtil;
import org.overlord.rtgov.common.util.RTGovProperties;

@Singleton
public class RESTActivityServer
implements ActivityServer {
    private static final Logger LOG = Logger.getLogger(RESTActivityServer.class.getName());
    private static final String STORE = "/overlord-rtgov/activity/store";
    private static final String UNIT = "/overlord-rtgov/activity/unit";
    private static final String QUERY = "/overlord-rtgov/activity/query";
    private static final String EVENTS = "/overlord-rtgov/activity/events";
    private String _serverURL = RTGovProperties.getProperty((String)"RESTActivityServer.serverURL", (String)"http://localhost:8080");
    private String _serverUsername = RTGovProperties.getProperty((String)"RESTActivityServer.serverUsername", (String)"");
    private String _serverPassword = RTGovProperties.getProperty((String)"RESTActivityServer.serverPassword", (String)"");

    public void setServerURL(String url) {
        this._serverURL = url;
    }

    public String getServerURL() {
        return this._serverURL;
    }

    public void setServerUsername(String username) {
        this._serverUsername = username;
    }

    public String getServerUsername() {
        return this._serverUsername;
    }

    public void setServerPassword(String password) {
        this._serverPassword = password;
    }

    public String getServerPassword() {
        return this._serverPassword;
    }

    protected void initAuth(HttpURLConnection connection) {
        String userPassword = this._serverUsername + ":" + this._serverPassword;
        String encoding = Base64.encodeBase64String((byte[])userPassword.getBytes());
        StringBuffer buf = new StringBuffer(encoding);
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isWhitespace(buf.charAt(i))) continue;
            buf.deleteCharAt(i);
            --i;
        }
        connection.setRequestProperty("Authorization", "Basic " + buf.toString());
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        URL storeUrl = new URL(this._serverURL + STORE);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + storeUrl + "] store: " + activities);
        }
        HttpURLConnection connection = (HttpURLConnection)storeUrl.openConnection();
        this.initAuth(connection);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        os.write(ActivityUtil.serializeActivityUnitList(activities));
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + new String(b));
        }
    }

    public ActivityUnit getActivityUnit(String id) throws Exception {
        ActivityUnit ret = null;
        URL queryUrl = new URL(this._serverURL + UNIT + "?id=" + id);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] getActivityUnit: " + id);
        }
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        this.initAuth(connection);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        ret = ActivityUtil.deserializeActivityUnit((byte[])b);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityUnit result: " + ret);
        }
        return ret;
    }

    public List<ActivityType> getActivityTypes(Context context, long from, long to) throws Exception {
        URL queryUrl = new URL(this._serverURL + EVENTS + "?type=" + context.getType() + "&value=" + context.getValue() + "&from=" + from + "&to=" + to);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] getActivityTypes: " + context + " from=" + from + " to=" + to);
        }
        return this.getActivityTypes(queryUrl);
    }

    public List<ActivityType> getActivityTypes(Context context) throws Exception {
        URL queryUrl = new URL(this._serverURL + EVENTS + "?type=" + context.getType() + "&value=" + context.getValue());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] getActivityTypes: " + context);
        }
        return this.getActivityTypes(queryUrl);
    }

    protected List<ActivityType> getActivityTypes(URL queryUrl) throws Exception {
        List ret = null;
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        this.initAuth(connection);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        ret = ActivityUtil.deserializeActivityTypeList((byte[])b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityTypes result: " + ret);
        }
        return ret;
    }

    public List<ActivityType> query(QuerySpec query) throws Exception {
        List ret = null;
        URL queryUrl = new URL(this._serverURL + QUERY);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] query: " + query);
        }
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        this.initAuth(connection);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        byte[] b = ActivityUtil.serializeQuerySpec((QuerySpec)query);
        os.write(b);
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        b = new byte[is.available()];
        is.read(b);
        ret = ActivityUtil.deserializeActivityTypeList((byte[])b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + ret);
        }
        return ret;
    }
}

