/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.collector;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.collector.ActivityCollector;

public final class ActivityCollectorAccessor {
    private static final int DEFAULT_WAIT_TIME = 300000;
    private static final Logger LOG = Logger.getLogger(ActivityCollectorAccessor.class.getName());
    private static ActivityCollector _activityCollector = null;
    private static final Object SYNC = new Object();

    private ActivityCollectorAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setActivityCollector(ActivityCollector collector) {
        Object object = SYNC;
        synchronized (object) {
            if (_activityCollector != null) {
                LOG.severe("Activity collector already set");
            }
            _activityCollector = collector;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Set activity collector=" + collector);
            }
            SYNC.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityCollector getActivityCollector() {
        if (_activityCollector == null) {
            Object object = SYNC;
            synchronized (object) {
                if (_activityCollector == null) {
                    try {
                        SYNC.wait(ActivityCollectorAccessor.getWaitTime());
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to wait for ActivityCollector to become available", e);
                    }
                    if (_activityCollector == null) {
                        LOG.severe("ActivityCollector is not available");
                    }
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Get activity collector=" + _activityCollector);
        }
        return _activityCollector;
    }

    private static long getWaitTime() {
        String waitTimeVal = System.getProperty("org.overlord.ServiceWaitTime");
        long waitTime = 300000L;
        if (waitTimeVal != null) {
            try {
                waitTime = Long.parseLong(waitTimeVal);
            }
            catch (NumberFormatException nfe) {
                LOG.warning("Failed to parse ServiceWaitTime " + waitTimeVal + ", using default value of " + waitTime);
            }
        }
        return waitTime;
    }
}

