/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.model.bpm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Entity;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.Context;

@Entity
public abstract class BPMActivityType
extends ActivityType
implements Externalizable {
    private static final int VERSION = 1;
    private String _processType = null;
    private String _instanceId = null;

    public BPMActivityType() {
    }

    public BPMActivityType(BPMActivityType ba) {
        super(ba);
        this._processType = ba._processType;
        this._instanceId = ba._instanceId;
    }

    public void setProcessType(String processType) {
        this._processType = processType;
        this.updateEndpointContext();
    }

    public String getProcessType() {
        return this._processType;
    }

    public void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
        this.updateEndpointContext();
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    protected void updateEndpointContext() {
        Context current = null;
        try {
            for (Context context : this.getContext()) {
                if (context.getType() != Context.Type.Endpoint) continue;
                current = context;
                break;
            }
            if (current == null) {
                current = new Context();
                current.setType(Context.Type.Endpoint);
                this.getContext().add(current);
            }
            String endpoint = "";
            if (this._processType != null) {
                endpoint = this._processType;
                if (this._instanceId != null) {
                    endpoint = endpoint + ":";
                }
            }
            if (this._instanceId != null) {
                endpoint = endpoint + this._instanceId;
            }
            current.setValue(endpoint);
        }
        catch (Throwable t) {
            current = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + " processType=" + this._processType + " instanceId=" + this._instanceId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
        out.writeObject(this._processType);
        out.writeObject(this._instanceId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        in.readInt();
        this._processType = (String)in.readObject();
        this._instanceId = (String)in.readObject();
    }
}

