/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.overlord.rtgov.activity.server.ActivityStore;
import org.overlord.rtgov.activity.server.ActivityStoreFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());

    public void start(final BundleContext context) throws Exception {
        ServiceListener sl = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        Activator.this.register(context, sr);
                        break;
                    }
                }
            }
        };
        String filter = "(objectclass=" + ActivityStore.class.getName() + ")";
        try {
            context.addServiceListener(sl, filter);
        }
        catch (InvalidSyntaxException e) {
            LOG.log(Level.SEVERE, "Failed to add service listener for activity store", e);
        }
        ServiceReference[] srefs = context.getServiceReferences(ActivityStore.class.getName(), null);
        if (srefs != null) {
            for (int i = 0; i < srefs.length; ++i) {
                this.register(context, srefs[i]);
            }
        }
    }

    protected void register(BundleContext context, ServiceReference actStoreRef) {
        ActivityStore actStore = (ActivityStore)context.getService(actStoreRef);
        ActivityStoreFactory.initialize(actStore);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

