/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.processor.InformationProcessor;
import org.overlord.rtgov.activity.processor.InformationProcessorManager;
import org.overlord.rtgov.activity.processor.InformationProcessorManagerAccessor;
import org.overlord.rtgov.common.util.VersionUtil;

public abstract class AbstractInformationProcessorManager
implements InformationProcessorManager {
    private static final Logger LOG = Logger.getLogger(AbstractInformationProcessorManager.class.getName());
    private Map<String, InformationProcessor> _informationProcessorIndex = new HashMap<String, InformationProcessor>();
    private List<InformationProcessor> _informationProcessors = new ArrayList<InformationProcessor>();

    public AbstractInformationProcessorManager() {
        InformationProcessorManagerAccessor.setInformationProcessorManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(InformationProcessor ip) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register: information processor name=" + ip.getName() + " version=" + ip.getVersion() + " ip=" + ip);
        }
        ip.init();
        Map<String, InformationProcessor> map = this._informationProcessorIndex;
        synchronized (map) {
            boolean f_add = false;
            InformationProcessor existing = this._informationProcessorIndex.get(ip.getName());
            if (existing != null) {
                if (VersionUtil.isNewerVersion((String)existing.getVersion(), (String)ip.getVersion())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Replace existing information processor version=" + existing.getVersion());
                    }
                    this.unregister(existing);
                    f_add = true;
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Newer version '" + existing.getVersion() + "' already registered");
                }
            } else {
                f_add = true;
            }
            if (f_add) {
                this._informationProcessorIndex.put(ip.getName(), ip);
                this._informationProcessors.add(ip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InformationProcessor getInformationProcessor(String name) {
        Map<String, InformationProcessor> map = this._informationProcessorIndex;
        synchronized (map) {
            return this._informationProcessorIndex.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(String processor, String type, Object info, Map<String, Object> headers, ActivityType actType) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process: processor=" + processor + " type=" + type + " info=" + info + " actType=" + actType);
        }
        Map<String, InformationProcessor> map = this._informationProcessorIndex;
        synchronized (map) {
            if (processor != null) {
                InformationProcessor ip = this._informationProcessorIndex.get(processor);
                if (ip.isSupported(type)) {
                    return ip.process(type, info, headers, actType);
                }
            } else {
                for (int i = 0; i < this._informationProcessors.size(); ++i) {
                    if (!this._informationProcessors.get(i).isSupported(type)) continue;
                    return this._informationProcessors.get(i).process(type, info, headers, actType);
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process: processor=" + processor + " type=" + type + " not supported");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(InformationProcessor ip) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister: information processor name=" + ip.getName() + " version=" + ip.getVersion() + " ip=" + ip);
        }
        Map<String, InformationProcessor> map = this._informationProcessorIndex;
        synchronized (map) {
            if (this._informationProcessors.contains(ip)) {
                InformationProcessor removed = this._informationProcessorIndex.remove(ip.getName());
                this._informationProcessors.remove(removed);
                removed.close();
            } else if (this._informationProcessorIndex.containsKey(ip.getName()) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Another version of information processor name=" + ip.getName() + " is currently registered: existing version =" + this._informationProcessorIndex.get(ip.getName()).getVersion());
            }
        }
    }
}

