/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.processor.InformationProcessorManager;

public final class InformationProcessorManagerAccessor {
    private static final int DEFAULT_WAIT_TIME = 300000;
    private static final Logger LOG = Logger.getLogger(InformationProcessorManagerAccessor.class.getName());
    private static InformationProcessorManager _informationProcessorManager = null;
    private static final Object SYNC = new Object();

    private InformationProcessorManagerAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setInformationProcessorManager(InformationProcessorManager ipm) {
        Object object = SYNC;
        synchronized (object) {
            if (_informationProcessorManager != null) {
                LOG.severe("Information processor manager already set");
            }
            _informationProcessorManager = ipm;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Set information processor manager=" + ipm);
            }
            SYNC.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InformationProcessorManager getInformationProcessorManager() {
        if (_informationProcessorManager == null) {
            Object object = SYNC;
            synchronized (object) {
                if (_informationProcessorManager == null) {
                    try {
                        SYNC.wait(InformationProcessorManagerAccessor.getWaitTime());
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to wait for InformationProcessorManager to become available", e);
                    }
                    if (_informationProcessorManager == null) {
                        LOG.severe("InformationProcessorManager is not available");
                    }
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Get information processor manager=" + _informationProcessorManager);
        }
        return _informationProcessorManager;
    }

    private static long getWaitTime() {
        String waitTimeVal = System.getProperty("org.overlord.ServiceWaitTime");
        long waitTime = 300000L;
        if (waitTimeVal != null) {
            try {
                waitTime = Long.parseLong(waitTimeVal);
            }
            catch (NumberFormatException nfe) {
                LOG.warning("Failed to parse ServiceWaitTime " + waitTimeVal + ", using default value of " + waitTime);
            }
        }
        return waitTime;
    }
}

