/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.overlord.rtgov.activity.processor.InformationTransformer;
import org.overlord.rtgov.activity.util.ActivityUtil;
import org.w3c.dom.Node;

public class SerializeInformationTransformer
extends InformationTransformer {
    private static final Logger LOG = Logger.getLogger(SerializeInformationTransformer.class.getName());

    @Override
    public String transform(Object information) {
        if (information instanceof String) {
            return (String)information;
        }
        if (information instanceof DOMSource) {
            information = ((DOMSource)information).getNode();
        }
        if (information instanceof Node) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DOMSource source = new DOMSource((Node)information);
                StreamResult result = new StreamResult(baos);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(source, result);
                return baos.toString();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to transformer DOM information '" + information + "'", e);
            }
        } else {
            try {
                return ActivityUtil.objectToJSONString(information);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to transformer information '" + information + "' to JSON", e);
            }
        }
        return null;
    }
}

