/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor.validation;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.processor.InformationProcessor;
import org.overlord.rtgov.activity.processor.TypeProcessor;
import org.overlord.rtgov.activity.processor.validation.IPValidationListener;

public final class IPValidator {
    private IPValidator() {
    }

    public static boolean validate(InformationProcessor ip, IPValidationListener l) {
        boolean ret = true;
        if (!IPValidator.validateInformationProcessor(ip, l)) {
            ret = false;
        }
        if (!IPValidator.validateTypeProcessors(ip, l)) {
            ret = false;
        }
        return ret;
    }

    protected static boolean validateInformationProcessor(InformationProcessor ip, IPValidationListener l) {
        boolean ret = true;
        if (ip.getName() == null) {
            l.error(ip, ip, MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-14"), "Information Processor", "name"));
            ret = false;
        }
        if (ip.getVersion() == null) {
            l.error(ip, ip, MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-14"), "Information Processor", "version"));
            ret = false;
        }
        return ret;
    }

    protected static boolean validateTypeProcessors(InformationProcessor ip, IPValidationListener l) {
        boolean ret = true;
        for (TypeProcessor tp : ip.getTypeProcessors().values()) {
            if (!IPValidator.validateContextEvaluators(ip, tp, l)) {
                ret = false;
            }
            if (IPValidator.validatePropertyEvaluators(ip, tp, l)) continue;
            ret = false;
        }
        return ret;
    }

    protected static boolean validateContextEvaluators(InformationProcessor ip, TypeProcessor tp, IPValidationListener l) {
        boolean ret = true;
        for (TypeProcessor.ContextEvaluator ce : tp.getContexts()) {
            if (ce.getEvaluator() == null) {
                l.error(ip, ce, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-15"));
                ret = false;
            }
            if (ce.getTimeframe() == 0L || ce.getType() == Context.Type.Link) continue;
            l.error(ip, ce, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-16"));
            ret = false;
        }
        return ret;
    }

    protected static boolean validatePropertyEvaluators(InformationProcessor ip, TypeProcessor tp, IPValidationListener l) {
        boolean ret = true;
        for (TypeProcessor.PropertyEvaluator pe : tp.getProperties()) {
            if (pe.getName() == null) {
                l.error(ip, ip, MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-14"), "Property Evaluator", "name"));
                ret = false;
            }
            if (pe.getEvaluator() != null) continue;
            l.error(ip, pe, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-17"));
            ret = false;
        }
        return ret;
    }
}

