/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor.xpath;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.jaxen.javabean.JavaBeanXPath;
import org.overlord.rtgov.activity.processor.ExpressionEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathExpressionEvaluator
extends ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(XPathExpressionEvaluator.class.getName());
    private DOMXPath _domXPath = null;
    private JavaBeanXPath _beanXPath = null;
    private Map<String, String> _namespaces = new HashMap<String, String>();

    public void setNamespaces(Map<String, String> namespaces) {
        this._namespaces = namespaces;
    }

    public Map<String, String> getNamespaces() {
        return this._namespaces;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this._domXPath = new DOMXPath(this.getExpression());
        this._beanXPath = new JavaBeanXPath(this.getExpression());
        if (this._namespaces != null) {
            this._domXPath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this._namespaces));
        }
    }

    @Override
    public String evaluate(Object information) {
        String ret = null;
        try {
            boolean reparse = false;
            if (information instanceof DOMSource) {
                information = ((DOMSource)information).getNode();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Extracted node from DOMSource: " + information);
                }
                if (this.getExpression().charAt(0) == '/' && ((Node)information).getParentNode() != ((Node)information).getOwnerDocument()) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Need to import supplied DOM node '" + information + "' into new document, as not the top level element " + "and the xpath expression starts with '/': " + this.getExpression());
                    }
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    information = doc.importNode((Node)information, true);
                    doc.appendChild((Node)information);
                }
            }
            if (information instanceof String) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream is = new ByteArrayInputStream(((String)information).getBytes());
                Document doc = builder.parse(is);
                ((InputStream)is).close();
                ret = this._domXPath.stringValueOf((Object)doc.getDocumentElement());
            } else if (information instanceof Node) {
                Node node = (Node)information;
                if (reparse || !XPathExpressionEvaluator.isNamespaceAware(node)) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Converting non-namespace-aware node: " + node);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DOMSource source = new DOMSource(node);
                    StreamResult result = new StreamResult(baos);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(source, result);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    Document doc = builder.parse(is);
                    ((InputStream)is).close();
                    information = doc.getDocumentElement();
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Converted node: " + information);
                    }
                }
                ret = this._domXPath.stringValueOf(information);
            } else {
                ret = this._beanXPath.stringValueOf(information);
            }
            if (ret != null && ret.length() == 0) {
                ret = null;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-6"), this.getExpression()), e);
        }
        return ret;
    }

    protected static boolean isNamespaceAware(Node node) {
        boolean ret;
        boolean bl = ret = node.getLocalName() != null;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Is node " + node + " namespace aware? " + ret);
            LOG.finest("nodeName=" + node.getNodeName());
            LOG.finest("localName=" + node.getLocalName());
            LOG.finest("namespace=" + node.getNamespaceURI());
        }
        return ret;
    }
}

