/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.overlord.rtgov.activity.processor.InformationTransformer;
import org.w3c.dom.Node;

public class XSLTInformationTransformer
extends InformationTransformer {
    private String _styleSheet = null;
    private Transformer _transformer = null;
    private static final Logger LOG = Logger.getLogger(XSLTInformationTransformer.class.getName());

    public String getStyleSheet() {
        return this._styleSheet;
    }

    public void setStyleSheet(String stylesheet) {
        this._styleSheet = stylesheet;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this._transformer == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._styleSheet);
            if (is == null) {
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-9"), this._styleSheet));
            } else {
                StreamSource xslt = new StreamSource(is);
                this._transformer = factory.newTransformer(xslt);
                is.close();
            }
        }
    }

    @Override
    public String transform(Object information) {
        if (this._transformer == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Transformer does not exist for information: " + information);
            }
            return null;
        }
        Source source = null;
        if (information instanceof String) {
            source = new StreamSource(new ByteArrayInputStream(((String)information).getBytes()));
        } else if (information instanceof Node) {
            source = new DOMSource((Node)information);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult target = new StreamResult(baos);
        try {
            this._transformer.transform(source, target);
            baos.flush();
            baos.close();
            return baos.toString();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Transformation failed", e);
            return null;
        }
    }
}

