/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.server;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.server.ActivityStore;
import org.overlord.rtgov.common.util.RTGovProperties;

public final class ActivityStoreFactory {
    private static final Logger LOG = Logger.getLogger(ActivityStoreFactory.class.getName());
    public static final String ACTIVITY_STORE_CLASS = "ActivityStore.class";
    private static ActivityStore _instance;

    private ActivityStoreFactory() {
    }

    public static synchronized void initialize(ActivityStore store) {
        if (_instance != null) {
            return;
        }
        String clsName = (String)RTGovProperties.getProperties().get(ACTIVITY_STORE_CLASS);
        if (clsName == null || store.getClass().getName().equals(clsName)) {
            _instance = store;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Initialize activity store instance=" + _instance);
            }
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Ignoring activity store initialization due to incorrect type [" + store.getClass().getName() + "], expecting [" + clsName + "]");
        }
    }

    public static synchronized ActivityStore getActivityStore() {
        if (_instance == null) {
            try {
                String clsName = (String)RTGovProperties.getProperties().get(ACTIVITY_STORE_CLASS);
                if (clsName != null) {
                    try {
                        Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
                        _instance = (ActivityStore)cls.newInstance();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.FINEST, "Failed to find activity store class '" + clsName + "'", t);
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.FINEST, "Failed to get activity store class property", t);
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Activity store instance=" + _instance);
        }
        return _instance;
    }
}

