/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.server.QuerySpec;

public final class ActivityUtil {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<List<ActivityUnit>> ACTIVITY_UNIT_LIST = new TypeReference<List<ActivityUnit>>(){};
    private static final TypeReference<List<ActivityType>> ACTIVITY_TYPE_LIST = new TypeReference<List<ActivityType>>(){};
    private static ObjectWriter ATLIST_WRITER = null;

    private ActivityUtil() {
    }

    public static byte[] serializeActivityUnit(ActivityUnit act) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)act);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static byte[] serializeQuerySpec(QuerySpec qs) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)qs);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static String objectToJSONString(Object obj) throws Exception {
        String ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, obj);
        ret = new String(baos.toByteArray());
        baos.close();
        return ret;
    }

    public static byte[] serializeActivityUnitList(List<ActivityUnit> activities) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, activities);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static byte[] serializeActivityTypeList(List<ActivityType> activities) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ATLIST_WRITER.writeValue((OutputStream)baos, activities);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static ActivityUnit deserializeActivityUnit(byte[] act) throws Exception {
        ActivityUnit ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(act);
        ret = (ActivityUnit)MAPPER.readValue((InputStream)bais, ActivityUnit.class);
        bais.close();
        return ret;
    }

    public static QuerySpec deserializeQuerySpec(byte[] qs) throws Exception {
        QuerySpec ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(qs);
        ret = (QuerySpec)MAPPER.readValue((InputStream)bais, QuerySpec.class);
        bais.close();
        return ret;
    }

    public static List<ActivityUnit> deserializeActivityUnitList(byte[] act) throws Exception {
        List ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(act);
        ret = (List)MAPPER.readValue((InputStream)bais, ACTIVITY_UNIT_LIST);
        bais.close();
        return ret;
    }

    public static List<ActivityType> deserializeActivityTypeList(byte[] act) throws Exception {
        List ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(act);
        ret = (List)MAPPER.readValue((InputStream)bais, ACTIVITY_TYPE_LIST);
        bais.close();
        return ret;
    }

    static {
        SerializationConfig config = MAPPER.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).withSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        MAPPER.setSerializationConfig(config);
        ATLIST_WRITER = MAPPER.writerWithType(ACTIVITY_TYPE_LIST);
    }
}

