/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.validator;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.validator.ActivityValidatorManager;

public final class ActivityValidatorManagerAccessor {
    private static final int DEFAULT_WAIT_TIME = 300000;
    private static final Logger LOG = Logger.getLogger(ActivityValidatorManagerAccessor.class.getName());
    private static ActivityValidatorManager _activityValidatorManager = null;
    private static final Object SYNC = new Object();

    private ActivityValidatorManagerAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setActivityValidatorManager(ActivityValidatorManager avm) {
        Object object = SYNC;
        synchronized (object) {
            if (_activityValidatorManager != null) {
                LOG.severe("Activity validator manager already set");
            }
            _activityValidatorManager = avm;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Set activity validator manager=" + avm);
            }
            SYNC.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityValidatorManager getActivityValidatorManager() {
        if (_activityValidatorManager == null) {
            Object object = SYNC;
            synchronized (object) {
                if (_activityValidatorManager == null) {
                    try {
                        SYNC.wait(ActivityValidatorManagerAccessor.getWaitTime());
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to wait for ActivityValidatorManager to become available", e);
                    }
                    if (_activityValidatorManager == null) {
                        LOG.severe("ActivityValidatorManager is not available");
                    }
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Get activity validator manager=" + _activityValidatorManager);
        }
        return _activityValidatorManager;
    }

    private static long getWaitTime() {
        String waitTimeVal = System.getProperty("org.overlord.ServiceWaitTime");
        long waitTime = 300000L;
        if (waitTimeVal != null) {
            try {
                waitTime = Long.parseLong(waitTimeVal);
            }
            catch (NumberFormatException nfe) {
                LOG.warning("Failed to parse ServiceWaitTime " + waitTimeVal + ", using default value of " + waitTime);
            }
        }
        return waitTime;
    }
}

