/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.collector;

import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.overlord.commons.services.ServiceClose;
import org.overlord.commons.services.ServiceInit;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.activity.collector.AbstractActivityCollectorMBean;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.collector.ActivityUnitLogger;
import org.overlord.rtgov.activity.collector.CollectorContext;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Origin;
import org.overlord.rtgov.activity.processor.InformationProcessorManager;
import org.overlord.rtgov.activity.validator.ActivityValidatorManager;
import org.overlord.rtgov.common.util.RTGovProperties;

public abstract class AbstractActivityCollector
implements ActivityCollector,
AbstractActivityCollectorMBean {
    private static final Logger LOG = Logger.getLogger(AbstractActivityCollector.class.getName());
    private static final boolean DEFAULT_COLLECTION_ENABLED = true;
    private Boolean _enabled;
    private CollectorContext _collectorContext = null;
    private ActivityUnitLogger _activityLogger = null;
    private InformationProcessorManager _infoProcessorManager = null;
    private ActivityValidatorManager _activityValidatorManager = null;
    private ThreadLocalStack<ActivityUnit> _activityUnit = new ThreadLocalStack();

    public AbstractActivityCollector() {
        this._enabled = RTGovProperties.getPropertyAsBoolean((String)"ActivityCollector.enabled", (Boolean)true);
    }

    @ServiceInit
    public void init() {
        if (this._infoProcessorManager == null) {
            ServiceRegistryUtil.addServiceListener(InformationProcessorManager.class, (ServiceListener)new ServiceListener<InformationProcessorManager>(){

                public void registered(InformationProcessorManager service) {
                    AbstractActivityCollector.this.setInformationProcessorManager(service);
                }

                public void unregistered(InformationProcessorManager service) {
                    AbstractActivityCollector.this.setInformationProcessorManager(null);
                }
            });
        }
        if (this._activityValidatorManager == null) {
            ServiceRegistryUtil.addServiceListener(ActivityValidatorManager.class, (ServiceListener)new ServiceListener<ActivityValidatorManager>(){

                public void registered(ActivityValidatorManager service) {
                    AbstractActivityCollector.this.setActivityValidatorManager(service);
                }

                public void unregistered(ActivityValidatorManager service) {
                    AbstractActivityCollector.this.setActivityValidatorManager(null);
                }
            });
        }
        if (this._collectorContext == null) {
            ServiceRegistryUtil.addServiceListener(CollectorContext.class, (ServiceListener)new ServiceListener<CollectorContext>(){

                public void registered(CollectorContext service) {
                    AbstractActivityCollector.this.setCollectorContext(service);
                }

                public void unregistered(CollectorContext service) {
                    AbstractActivityCollector.this.setCollectorContext(null);
                }
            });
        }
        if (this._activityLogger == null) {
            ServiceRegistryUtil.addServiceListener(ActivityUnitLogger.class, (ServiceListener)new ServiceListener<ActivityUnitLogger>(){

                public void registered(ActivityUnitLogger service) {
                    AbstractActivityCollector.this.setActivityUnitLogger(service);
                }

                public void unregistered(ActivityUnitLogger service) {
                    AbstractActivityCollector.this.setActivityUnitLogger(null);
                }
            });
        }
    }

    public void setCollectorContext(CollectorContext cc) {
        this._collectorContext = cc;
    }

    public CollectorContext getCollectorContext() {
        return this._collectorContext;
    }

    @Override
    public boolean isCollectionEnabled() {
        return this._enabled == null ? true : this._enabled;
    }

    @Override
    public boolean getCollectionEnabled() {
        return this.isCollectionEnabled();
    }

    @Override
    public void setCollectionEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setActivityUnitLogger(ActivityUnitLogger activityLogger) {
        this._activityLogger = activityLogger;
    }

    public ActivityUnitLogger getActivityUnitLogger() {
        return this._activityLogger;
    }

    public InformationProcessorManager getInformationProcessorManager() {
        return this._infoProcessorManager;
    }

    public void setInformationProcessorManager(InformationProcessorManager ipm) {
        this._infoProcessorManager = ipm;
    }

    public ActivityValidatorManager getActivityValidatorManager() {
        return this._activityValidatorManager;
    }

    public void setActivityValidatorManager(ActivityValidatorManager aim) {
        this._activityValidatorManager = aim;
    }

    protected String createTransactionId() {
        return UUID.randomUUID().toString();
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public void startScope() {
        if (!this.isCollectionEnabled()) {
            return;
        }
        ActivityUnit au = this._activityUnit.get();
        if (au != null && LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Starting nested scope");
        }
        this.startScope(this.createActivityUnit());
    }

    @Override
    public boolean isScopeActive() {
        return this._activityUnit.get() != null;
    }

    protected void startScope(ActivityUnit au) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Start scope");
        }
        this._activityUnit.set(au);
    }

    protected ActivityUnit createActivityUnit() {
        ActivityUnit ret = new ActivityUnit();
        Origin origin = new Origin();
        origin.setHost(this._collectorContext.getHost());
        origin.setNode(this._collectorContext.getNode());
        origin.setThread(Thread.currentThread().getName());
        ret.setOrigin(origin);
        return ret;
    }

    @Override
    public void endScope() {
        if (!this.isCollectionEnabled()) {
            return;
        }
        ActivityUnit au = this._activityUnit.get();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("End scope for: " + au);
        }
        if (au != null) {
            this._activityLogger.log(au);
            this._activityUnit.remove();
        } else {
            LOG.severe(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-1"));
        }
    }

    @Override
    public String processInformation(String processor, String type, Object info, Map<String, Object> headers, ActivityType actType) {
        if (this._infoProcessorManager != null) {
            return this._infoProcessorManager.process(processor, type, info, headers, actType);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Information processor manager not specified: unable to process type '" + type + "' info: " + info);
        }
        return null;
    }

    @Override
    public void validate(ActivityType actType) throws Exception {
        if (this._activityValidatorManager != null) {
            this._activityValidatorManager.validate(actType);
        }
    }

    @Override
    public void record(ActivityType actType) {
        boolean transactional;
        ActivityUnit au;
        block10: {
            if (!this.isCollectionEnabled()) {
                return;
            }
            au = this._activityUnit.get();
            transactional = true;
            if (au == null) {
                au = this.createActivityUnit();
                TransactionManager tm = this._collectorContext.getTransactionManager();
                if (tm != null) {
                    try {
                        Transaction txn = tm.getTransaction();
                        if (txn != null) {
                            txn.registerSynchronization(new Synchronization(){

                                public void afterCompletion(int arg0) {
                                    AbstractActivityCollector.this.endScope();
                                }

                                public void beforeCompletion() {
                                }
                            });
                            this.startScope(au);
                            break block10;
                        }
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("No transaction available");
                        }
                        transactional = false;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-2"), e);
                        transactional = false;
                    }
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("No transaction manager available");
                    }
                    transactional = false;
                }
            }
        }
        actType.setTimestamp(this.getTimestamp());
        au.getActivityTypes().add(actType);
        if (!transactional) {
            this._activityLogger.log(au);
        }
    }

    @ServiceClose
    public void close() {
    }

    class ThreadLocalStack<T> {
        private ThreadLocal<Stack<T>> _threadLocalStack = new ThreadLocal();

        ThreadLocalStack() {
        }

        public T get() {
            Stack<T> stack = this._threadLocalStack.get();
            if (stack == null || stack.isEmpty()) {
                return null;
            }
            return stack.peek();
        }

        public void set(T value) {
            Stack<T> stack = this._threadLocalStack.get();
            if (stack == null) {
                this._threadLocalStack.set(new Stack());
                stack = this._threadLocalStack.get();
            }
            stack.push(value);
        }

        public void remove() {
            Stack<T> stack = this._threadLocalStack.get();
            if (stack == null) {
                return;
            }
            stack.pop();
        }
    }
}

