/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.collector;

import java.lang.management.ManagementFactory;
import java.util.PropertyResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.overlord.rtgov.activity.collector.ActivityUnitLogger;
import org.overlord.rtgov.activity.collector.BatchedActivityUnitLoggerMBean;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.common.util.RTGovProperties;

public abstract class BatchedActivityUnitLogger
implements ActivityUnitLogger,
BatchedActivityUnitLoggerMBean {
    private static final Logger LOG = Logger.getLogger(BatchedActivityUnitLogger.class.getName());
    private static final int MAX_UNIT_COUNT = 1000;
    private static final long MAX_TIME_INTERVAL = 500L;
    private static final String OBJECT_NAME_DOMAIN = "overlord.rtgov.collector";
    private static final String OBJECT_NAME_LOGGER = "overlord.rtgov.collector:name=ActivityLogger";
    private int _messageCounter = 0;
    private Timer _timer;
    private TimerTask _timerTask;
    private Long _maxTimeInterval;
    private Integer _maxUnitCount;
    private boolean _initialized = false;

    @Override
    public synchronized void init() {
        if (!this._initialized) {
            this._timer = new Timer();
            this._maxTimeInterval = RTGovProperties.getPropertyAsLong((String)"BatchedActivityUnitLogger.maxTimeInterval", (Long)500L);
            this._maxUnitCount = RTGovProperties.getPropertyAsInteger((String)"BatchedActivityUnitLogger.maxUnitCount", (Integer)1000);
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Register the ActivityUnitLogger MBean[overlord.rtgov.collector:name=ActivityLogger]: " + this);
                }
                ObjectName objname2 = new ObjectName(OBJECT_NAME_LOGGER);
                mbs.registerMBean(this, objname2);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-18"), e);
            }
            this._initialized = true;
        }
    }

    @Override
    public void setMaxTimeInterval(long max) {
        this._maxTimeInterval = max;
    }

    @Override
    public long getMaxTimeInterval() {
        if (this._maxTimeInterval == null) {
            return 500L;
        }
        return this._maxTimeInterval;
    }

    @Override
    public void setMaxUnitCount(int max) {
        this._maxUnitCount = max;
    }

    @Override
    public int getMaxUnitCount() {
        if (this._maxUnitCount == null) {
            return 1000;
        }
        return this._maxUnitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(ActivityUnit act) {
        try {
            Timer timer = this._timer;
            synchronized (timer) {
                if (this._timerTask == null) {
                    this._timerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Timer timer = BatchedActivityUnitLogger.this._timer;
                                synchronized (timer) {
                                    BatchedActivityUnitLogger.this.sendMessage();
                                    BatchedActivityUnitLogger.this.reset();
                                }
                            }
                            catch (Exception e) {
                                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-3"), e);
                            }
                        }
                    };
                    this._timer.schedule(this._timerTask, this.getMaxTimeInterval());
                }
                this.appendActivity(act);
                ++this._messageCounter;
                if (this._messageCounter > this.getMaxUnitCount()) {
                    this.sendMessage();
                    this.reset();
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-3"), e);
        }
    }

    protected abstract void appendActivity(ActivityUnit var1) throws Exception;

    protected abstract void sendMessage() throws Exception;

    protected void reset() {
        this._messageCounter = 0;
        if (this._timerTask != null) {
            this._timerTask.cancel();
            this._timerTask = null;
        }
    }

    @Override
    public void close() {
        block3: {
            this._timer.cancel();
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Unregister the ActivityUnitLogger MBean[overlord.rtgov.collector:name=ActivityLogger]: " + this);
                }
                ObjectName objname2 = new ObjectName(OBJECT_NAME_LOGGER);
                mbs.unregisterMBean(objname2);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINER)) break block3;
                LOG.log(Level.FINER, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-19"), t);
            }
        }
    }
}

