/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.codehaus.enunciate.json.JsonRootType;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.model.app.CustomActivity;
import org.overlord.rtgov.activity.model.app.LogMessage;
import org.overlord.rtgov.activity.model.bpm.ProcessCompleted;
import org.overlord.rtgov.activity.model.bpm.ProcessStarted;
import org.overlord.rtgov.activity.model.bpm.ProcessVariableSet;
import org.overlord.rtgov.activity.model.mom.MessageReceived;
import org.overlord.rtgov.activity.model.mom.MessageSent;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=MessageReceived.class), @JsonSubTypes.Type(value=MessageSent.class), @JsonSubTypes.Type(value=RequestReceived.class), @JsonSubTypes.Type(value=RequestSent.class), @JsonSubTypes.Type(value=ResponseReceived.class), @JsonSubTypes.Type(value=ResponseSent.class), @JsonSubTypes.Type(value=ProcessCompleted.class), @JsonSubTypes.Type(value=ProcessStarted.class), @JsonSubTypes.Type(value=ProcessVariableSet.class), @JsonSubTypes.Type(value=CustomActivity.class), @JsonSubTypes.Type(value=LogMessage.class)})
@Entity
@IdClass(value=ActivityTypeId.class)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="activityType", discriminatorType=DiscriminatorType.STRING)
@Table(name="RTGOV_ACTIVITIES")
@JsonRootType
public abstract class ActivityType
implements Externalizable {
    private static final int VERSION = 1;
    public static final String HEADER_FORMAT_PROPERTY_PREFIX = "_header-format_";
    public static final String RTGOV_PROPERTY_PREFIX = "_rtgov_";
    private String _unitId = null;
    private int _unitIndex = 0;
    private long _timestamp = 0L;
    private String _principal = null;
    private Set<Context> _contexts = new LinkedHashSet<Context>();
    private Map<String, String> _properties = new HashMap<String, String>();

    public ActivityType() {
    }

    public ActivityType(ActivityType act) {
        this._unitId = act._unitId;
        this._unitIndex = act._unitIndex;
        this._timestamp = act._timestamp;
        for (Context ctx : act._contexts) {
            this._contexts.add(new Context(ctx));
        }
        this._properties = new HashMap<String, String>(act._properties);
    }

    public void setUnitId(String id) {
        this._unitId = id;
    }

    @Id
    @Column(name="unitId")
    public String getUnitId() {
        return this._unitId;
    }

    public void setUnitIndex(int index) {
        this._unitIndex = index;
    }

    @Id
    @Column(name="unitIndex")
    public int getUnitIndex() {
        return this._unitIndex;
    }

    public void setPrincipal(String principal) {
        this._principal = principal;
    }

    public String getPrincipal() {
        return this._principal;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    @Column(name="tstamp")
    public long getTimestamp() {
        return this._timestamp;
    }

    public void setContext(Set<Context> context) {
        this._contexts = context;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="RTGOV_ACTIVITY_CONTEXT", joinColumns={@JoinColumn(name="unitId", referencedColumnName="unitId"), @JoinColumn(name="unitIndex", referencedColumnName="unitIndex")})
    public Set<Context> getContext() {
        return this._contexts;
    }

    public void setProperties(Map<String, String> props) {
        this._properties = props;
    }

    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @MapKeyColumn(name="name")
    @Column(name="value")
    @CollectionTable(name="RTGOV_ACTIVITY_PROPERTIES", joinColumns={@JoinColumn(name="unitId", referencedColumnName="unitId"), @JoinColumn(name="unitIndex", referencedColumnName="unitIndex")})
    public Map<String, String> getProperties() {
        return this._properties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._unitId);
        out.writeInt(this._unitIndex);
        out.writeLong(this._timestamp);
        out.writeObject(this._principal);
        int len = this._contexts.size();
        out.writeInt(len);
        Iterator<Context> iter = this._contexts.iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
        }
        out.writeObject(this._properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._unitId = (String)in.readObject();
        this._unitIndex = in.readInt();
        this._timestamp = in.readLong();
        this._principal = (String)in.readObject();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
        this._properties = (Map)in.readObject();
    }
}

