/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class Context
implements Externalizable {
    private static final int VERSION = 1;
    private Type _type = null;
    private String _value = null;
    private long _timeframe = 0L;

    public Context() {
    }

    public Context(Type type, String value) {
        this._type = type;
        this._value = value;
    }

    public Context(Context context) {
        this._type = context._type;
        this._value = context._value;
    }

    @Column(name="contextType")
    @Enumerated(value=EnumType.STRING)
    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
    }

    @Column(name="value")
    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean linkSource() {
        return this._type == Type.Link && this._timeframe != 0L;
    }

    public boolean linkTarget() {
        return this._type == Type.Link && this._timeframe == 0L;
    }

    @Column(name="timeframe")
    public long getTimeframe() {
        return this._timeframe;
    }

    public void setTimeframe(long timeframe) {
        this._timeframe = timeframe;
    }

    public int hashCode() {
        return this._value == null ? 0 : this._value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Context) {
            Context ctx = (Context)obj;
            if (ctx._type == this._type && (ctx._value != null && ctx._value.equals(this._value) || ctx._value == null && this._value == null)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Context[" + (Object)((Object)this._type) + ":" + this._value + ":" + this._timeframe + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject((Object)this._type);
        out.writeObject(this._value);
        out.writeLong(this._timeframe);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._type = (Type)((Object)in.readObject());
        this._value = (String)in.readObject();
        this._timeframe = in.readLong();
    }

    public static enum Type {
        Conversation,
        Endpoint,
        Message,
        Link;

    }
}

