/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.model.soa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.model.common.MessageExchange;

@Entity
public abstract class RPCActivityType
extends MessageExchange
implements Externalizable {
    private static final int VERSION = 2;
    private String _serviceType = null;
    private String _interface = null;
    private String _operation = null;
    private String _fault = null;
    private boolean _internal = false;

    public RPCActivityType() {
    }

    public RPCActivityType(RPCActivityType rpc) {
        super(rpc);
        this._serviceType = rpc._serviceType;
        this._interface = rpc._interface;
        this._operation = rpc._operation;
        this._fault = rpc._fault;
    }

    @Transient
    public abstract boolean isServiceProvider();

    @Transient
    public abstract boolean isRequest();

    public void setServiceType(String serviceType) {
        this._serviceType = serviceType;
    }

    public String getServiceType() {
        return this._serviceType;
    }

    public void setInterface(String intf) {
        this._interface = intf;
    }

    public String getInterface() {
        return this._interface;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public String getOperation() {
        return this._operation;
    }

    public void setFault(String fault) {
        this._fault = fault;
    }

    public String getFault() {
        return this._fault;
    }

    public void setInternal(boolean b) {
        this._internal = b;
    }

    @Transient
    public boolean getInternal() {
        return this._internal;
    }

    @Transient
    @JsonIgnore
    public String getMessageId() {
        for (Context context : this.getContext()) {
            if (context.getType() != Context.Type.Message) continue;
            return context.getValue();
        }
        return null;
    }

    public void setMessageId(String id) {
        Context current = null;
        for (Context context : this.getContext()) {
            if (context.getType() != Context.Type.Message) continue;
            current = context;
            break;
        }
        if (current == null) {
            current = new Context();
            current.setType(Context.Type.Message);
            this.getContext().add(current);
        }
        current.setValue(id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + " serviceType=" + this._serviceType + " interface=" + this._interface + " operation=" + this._operation + " fault=" + this._fault + " messageType=" + this.getMessageType() + " content=" + this.getContent();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(2);
        out.writeObject(this._serviceType);
        out.writeObject(this._interface);
        out.writeObject(this._operation);
        out.writeObject(this._fault);
        out.writeBoolean(this._internal);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = in.readInt();
        this._serviceType = (String)in.readObject();
        this._interface = (String)in.readObject();
        this._operation = (String)in.readObject();
        this._fault = (String)in.readObject();
        if (version >= 2) {
            this._internal = in.readBoolean();
        }
    }
}

