/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.processor.TypeProcessor;

public class InformationProcessor {
    private static final Logger LOG = Logger.getLogger(InformationProcessor.class.getName());
    private String _name = null;
    private String _version = null;
    private Map<String, TypeProcessor> _typeProcessors = new HashMap<String, TypeProcessor>();
    private boolean _initialized = false;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public Map<String, TypeProcessor> getTypeProcessors() {
        return this._typeProcessors;
    }

    public void init() throws Exception {
        if (!this._initialized) {
            this._initialized = true;
            for (TypeProcessor tp : this._typeProcessors.values()) {
                tp.init();
            }
        }
    }

    public boolean isSupported(String type) {
        return this._typeProcessors.containsKey(type);
    }

    public String process(String type, Object info, Map<String, Object> headers, ActivityType actType) {
        TypeProcessor processor = this._typeProcessors.get(type);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process type=" + type + " info=" + info + " actType=" + actType + " with processor=" + processor);
        }
        if (processor != null) {
            return processor.process(info, headers, actType);
        }
        return null;
    }

    public void close() throws Exception {
        for (TypeProcessor tp : this._typeProcessors.values()) {
            tp.close();
        }
    }
}

