/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.processor.InformationTransformer;
import org.overlord.rtgov.activity.util.ActivityUtil;
import org.w3c.dom.Node;

public class SerializeInformationTransformer
extends InformationTransformer {
    private static final Logger LOG = Logger.getLogger(SerializeInformationTransformer.class.getName());
    private boolean _includeHeaders = false;

    public void setIncludeHeaders(boolean b) {
        this._includeHeaders = b;
    }

    public boolean getIncludeHeaders() {
        return this._includeHeaders;
    }

    @Override
    public String transform(Object information, Map<String, Object> headers, ActivityType activityType) {
        String ret = this.transformToString(information, false);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Transform headers? '" + this.getIncludeHeaders());
        }
        if (this.getIncludeHeaders()) {
            if (headers == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Configuration indicates to include headers, but no headers supplied");
                }
            } else if (activityType == null) {
                LOG.severe("Cannot include headers as no activity type supplied");
            } else {
                for (String headerName : headers.keySet()) {
                    Object headerValue = headers.get(headerName);
                    String transformed = this.transformToString(headerValue, true);
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Transformed header='" + headerName + "' value='" + headerValue + "' into='" + transformed + "'");
                    }
                    if (transformed == null) continue;
                    String encoding = "text";
                    if (headerValue instanceof Node || headerValue instanceof DOMSource) {
                        encoding = "dom";
                    }
                    activityType.getProperties().put(headerName, transformed);
                    activityType.getProperties().put(this.getHeaderFormatPropertyName(headerName), encoding);
                }
            }
        }
        return ret;
    }

    protected String getHeaderFormatPropertyName(String headerName) {
        return "_header-format_" + headerName;
    }

    protected String transformToString(Object information, boolean header) {
        if (information instanceof String) {
            return (String)information;
        }
        if (information instanceof DOMSource) {
            information = ((DOMSource)information).getNode();
        }
        if (information instanceof Node) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DOMSource source = new DOMSource((Node)information);
                StreamResult result = new StreamResult(baos);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(source, result);
                return baos.toString();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to transformer DOM information '" + information + "'", e);
            }
        } else if (!header) {
            try {
                return ActivityUtil.objectToJSONString(information);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to transformer information '" + information + "' to JSON", e);
            }
        }
        return null;
    }
}

