/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.processor.ExpressionEvaluator;
import org.overlord.rtgov.activity.processor.InformationTransformer;
import org.overlord.rtgov.activity.processor.ScriptEvaluator;

public class TypeProcessor {
    private static final Logger LOG = Logger.getLogger(TypeProcessor.class.getName());
    private InformationTransformer _transformer = null;
    private List<ContextEvaluator> _contextEvaluators = new ArrayList<ContextEvaluator>();
    private List<PropertyEvaluator> _propertyEvaluators = new ArrayList<PropertyEvaluator>();
    private ScriptEvaluator _scriptEvaluator = null;

    public void init() throws Exception {
        if (this._transformer != null) {
            this._transformer.init();
        }
        for (ContextEvaluator ce : this._contextEvaluators) {
            ce.getEvaluator().init();
        }
        for (PropertyEvaluator pe : this._propertyEvaluators) {
            pe.getEvaluator().init();
        }
        if (this._scriptEvaluator != null) {
            this._scriptEvaluator.init();
        }
    }

    public InformationTransformer getTransformer() {
        return this._transformer;
    }

    public void setTransformer(InformationTransformer transformer) {
        this._transformer = transformer;
    }

    public List<ContextEvaluator> getContexts() {
        return this._contextEvaluators;
    }

    public void setContexts(List<ContextEvaluator> ce) {
        this._contextEvaluators = ce;
    }

    public List<PropertyEvaluator> getProperties() {
        return this._propertyEvaluators;
    }

    public void setProperties(List<PropertyEvaluator> pe) {
        this._propertyEvaluators = pe;
    }

    public ScriptEvaluator getScript() {
        return this._scriptEvaluator;
    }

    public void setScript(ScriptEvaluator script) {
        this._scriptEvaluator = script;
    }

    public String process(Object information, Map<String, Object> headers, ActivityType actType) {
        int i;
        String ret = null;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process information: " + information);
        }
        for (i = 0; i < this._contextEvaluators.size(); ++i) {
            ContextEvaluator ce = this._contextEvaluators.get(i);
            ce.process(information, headers, actType);
        }
        for (i = 0; i < this._propertyEvaluators.size(); ++i) {
            PropertyEvaluator pe = this._propertyEvaluators.get(i);
            pe.process(information, headers, actType);
        }
        if (this.getScript() != null) {
            this.getScript().evaluate(information, actType);
        }
        if (this.getTransformer() != null) {
            ret = this.getTransformer().transform(information, headers, actType);
        }
        return ret;
    }

    public void close() throws Exception {
        if (this._transformer != null) {
            this._transformer.close();
        }
        for (ContextEvaluator ce : this._contextEvaluators) {
            ce.getEvaluator().close();
        }
        for (PropertyEvaluator pe : this._propertyEvaluators) {
            pe.getEvaluator().close();
        }
        if (this._scriptEvaluator != null) {
            this._scriptEvaluator.close();
        }
    }

    public static class ContextEvaluator {
        private Context.Type _type = null;
        private long _timeframe = 0L;
        private String _header = null;
        private ExpressionEvaluator _evaluator = null;

        public Context.Type getType() {
            return this._type;
        }

        public void setType(Context.Type type) {
            this._type = type;
        }

        public long getTimeframe() {
            return this._timeframe;
        }

        public void setTimeframe(long timeframe) {
            this._timeframe = timeframe;
        }

        public String getHeader() {
            return this._header;
        }

        public void setHeader(String header) {
            this._header = header;
        }

        public ExpressionEvaluator getEvaluator() {
            return this._evaluator;
        }

        public void setEvaluator(ExpressionEvaluator evaluator) {
            this._evaluator = evaluator;
        }

        public void process(Object information, Map<String, Object> headers, ActivityType actType) {
            Object source = null;
            if (this.getHeader() != null) {
                if (headers != null && headers.containsKey(this.getHeader())) {
                    source = headers.get(this.getHeader());
                } else {
                    LOG.warning(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-12"), new Object[]{this.getType(), this.getHeader()}));
                }
            } else {
                source = information;
            }
            String val = null;
            if (source != null) {
                val = this.getEvaluator().evaluate(source);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Context evaluator '" + this + "' = " + val);
            }
            if (val != null) {
                Context context = new Context(this.getType(), val);
                context.setTimeframe(this._timeframe);
                actType.getContext().add(context);
            } else if (!this.getEvaluator().getOptional()) {
                if (this.getHeader() == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-7"), this.getEvaluator().getExpression(), information));
                } else {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-13"), new Object[]{this.getType(), this.getHeader()}));
                }
            }
        }

        public String toString() {
            return "[ type=" + (Object)((Object)this._type) + " expression=" + this._evaluator.getExpression() + " ]";
        }
    }

    public static class PropertyEvaluator {
        private String _name = null;
        private String _header = null;
        private ExpressionEvaluator _evaluator = null;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getHeader() {
            return this._header;
        }

        public void setHeader(String header) {
            this._header = header;
        }

        public ExpressionEvaluator getEvaluator() {
            return this._evaluator;
        }

        public void setEvaluator(ExpressionEvaluator evaluator) {
            this._evaluator = evaluator;
        }

        public void process(Object information, Map<String, Object> headers, ActivityType actType) {
            Object source = null;
            if (this.getHeader() != null) {
                if (headers != null && headers.containsKey(this.getHeader())) {
                    source = headers.get(this.getHeader());
                } else {
                    LOG.warning(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-10"), this.getName(), this.getHeader()));
                }
            } else {
                source = information;
            }
            String val = null;
            if (source != null) {
                val = this.getEvaluator().evaluate(source);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Property evaluator '" + this + "' = " + val);
            }
            if (val != null) {
                actType.getProperties().put(this.getName(), val);
            } else if (!this.getEvaluator().getOptional()) {
                if (this.getHeader() == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-8"), this.getEvaluator().getExpression(), information));
                } else {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-11"), this.getName(), this.getHeader()));
                }
            }
        }

        public String toString() {
            return "[ name=" + this._name + " header=" + this._header + " expression=" + this._evaluator.getExpression() + " ]";
        }
    }
}

