/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.server;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.activity.server.ActivityStore;
import org.overlord.rtgov.common.util.RTGovProperties;

public final class ActivityStoreFactory {
    private static final Logger LOG = Logger.getLogger(ActivityStoreFactory.class.getName());
    public static final String ACTIVITY_STORE_CLASS = "ActivityStore.class";
    private static ActivityStore _instance;

    private ActivityStoreFactory() {
    }

    public static void clear() {
        _instance = null;
    }

    public static ActivityStore getActivityStore() {
        if (_instance == null) {
            Set services = ServiceRegistryUtil.getServices(ActivityStore.class);
            String clsName = (String)RTGovProperties.getProperties().get(ACTIVITY_STORE_CLASS);
            for (ActivityStore as : services) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Checking activity store impl=" + as);
                }
                if (!as.getClass().getName().equals(clsName)) continue;
                if (_instance != null) break;
                _instance = as;
                if (!LOG.isLoggable(Level.FINEST)) break;
                LOG.finest("Found activity store impl=" + as);
                break;
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Activity store instance=" + _instance);
        }
        return _instance;
    }
}

