/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.commons.services.ServiceClose;
import org.overlord.commons.services.ServiceInit;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.validator.ActivityValidator;
import org.overlord.rtgov.activity.validator.ActivityValidatorManager;
import org.overlord.rtgov.common.util.VersionUtil;

public abstract class AbstractActivityValidatorManager
implements ActivityValidatorManager {
    private static final Logger LOG = Logger.getLogger(AbstractActivityValidatorManager.class.getName());
    private Map<String, ActivityValidator> _activityValidatorIndex = new HashMap<String, ActivityValidator>();
    private List<ActivityValidator> _activityValidators = new ArrayList<ActivityValidator>();

    @ServiceInit
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ActivityValidator ai) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register: activity validator name=" + ai.getName() + " version=" + ai.getVersion() + " ai=" + ai);
        }
        ai.init();
        Map<String, ActivityValidator> map = this._activityValidatorIndex;
        synchronized (map) {
            boolean f_add = false;
            ActivityValidator existing = this._activityValidatorIndex.get(ai.getName());
            if (existing != null) {
                if (VersionUtil.isNewerVersion((String)existing.getVersion(), (String)ai.getVersion())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Replace existing activity validator version=" + existing.getVersion());
                    }
                    this.unregister(existing);
                    f_add = true;
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Newer version '" + existing.getVersion() + "' already registered");
                }
            } else {
                f_add = true;
            }
            if (f_add) {
                this._activityValidatorIndex.put(ai.getName(), ai);
                this._activityValidators.add(ai);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityValidator getActivityValidator(String name) {
        Map<String, ActivityValidator> map = this._activityValidatorIndex;
        synchronized (map) {
            return this._activityValidatorIndex.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ActivityType actType) throws Exception {
        Map<String, ActivityValidator> map = this._activityValidatorIndex;
        synchronized (map) {
            for (int i = 0; i < this._activityValidators.size(); ++i) {
                this._activityValidators.get(i).validate(actType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ActivityValidator ai) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister: activity validator name=" + ai.getName() + " version=" + ai.getVersion() + " ai=" + ai);
        }
        Map<String, ActivityValidator> map = this._activityValidatorIndex;
        synchronized (map) {
            if (this._activityValidators.contains(ai)) {
                ActivityValidator removed = this._activityValidatorIndex.remove(ai.getName());
                this._activityValidators.remove(removed);
            } else if (this._activityValidatorIndex.containsKey(ai.getName()) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Another version of activity validator name=" + ai.getName() + " is currently registered: existing version =" + this._activityValidatorIndex.get(ai.getName()).getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ServiceClose
    public void close() throws Exception {
        Map<String, ActivityValidator> map = this._activityValidatorIndex;
        synchronized (map) {
            for (int i = this._activityValidators.size() - 1; i >= 0; --i) {
                this.unregister(this._activityValidators.get(i));
            }
        }
    }
}

