/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.util;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.common.util.DefaultRTGovPropertiesProvider;
import org.overlord.rtgov.common.util.RTGovPropertiesProvider;

public final class RTGovProperties {
    private static final Logger LOG = Logger.getLogger(RTGovProperties.class.getName());
    private static RTGovPropertiesProvider _provider = new DefaultRTGovPropertiesProvider();

    private RTGovProperties() {
    }

    public static void setPropertiesProvider(RTGovPropertiesProvider props) {
        _provider = props;
    }

    public static RTGovPropertiesProvider getPropertiesProvider() {
        return _provider;
    }

    public static String getProperty(String name) {
        String ret = null;
        if (RTGovProperties.getPropertiesProvider() != null) {
            ret = RTGovProperties.getPropertiesProvider().getProperty(name);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Runtime Governance property '" + name + "' = " + ret);
        }
        return ret;
    }

    public static String getProperty(String name, String def) {
        String ret = RTGovProperties.getProperty(name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static Boolean getPropertyAsBoolean(String name) {
        Boolean ret = null;
        String prop = RTGovProperties.getProperty(name);
        if (prop != null) {
            ret = Boolean.valueOf(prop);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Runtime Governance boolean value = " + ret);
            }
        }
        return ret;
    }

    public static Boolean getPropertyAsBoolean(String name, Boolean def) {
        Boolean ret = RTGovProperties.getPropertyAsBoolean(name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static Integer getPropertyAsInteger(String name) {
        Integer ret = null;
        String prop = RTGovProperties.getProperty(name);
        if (prop != null) {
            ret = Integer.valueOf(prop);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Runtime Governance integer value = " + ret);
            }
        }
        return ret;
    }

    public static Integer getPropertyAsInteger(String name, Integer def) {
        Integer ret = RTGovProperties.getPropertyAsInteger(name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static Long getPropertyAsLong(String name) {
        Long ret = null;
        String prop = RTGovProperties.getProperty(name);
        if (prop != null) {
            ret = Long.valueOf(prop);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Runtime Governance long value = " + ret);
            }
        }
        return ret;
    }

    public static Long getPropertyAsLong(String name, Long def) {
        Long ret = RTGovProperties.getPropertyAsLong(name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static Properties getProperties() {
        Properties ret = null;
        if (RTGovProperties.getPropertiesProvider() != null) {
            ret = RTGovProperties.getPropertiesProvider().getProperties();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Runtime Governance properties = " + ret);
        }
        return ret;
    }
}

