/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.jpa;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.overlord.rtgov.common.util.RTGovProperties;

public class JpaStore {
    private static final Logger LOG = Logger.getLogger(JpaStore.class.getName());
    private static final String JTA_PLATFORM_PROPERTY = "JpaStore.jtaPlatform";
    private URL _configXml;
    private String _jndiProperty;
    private SessionFactory _sessionFactory;
    @Deprecated
    private String _persistenceUnit;
    @Deprecated
    private EntityManagerFactory _entityManagerFactory;
    private boolean _isJta = true;

    public JpaStore(URL configXml, String jndiProperty) {
        this._configXml = configXml;
        this._jndiProperty = jndiProperty;
    }

    public JpaStore(URL configXml) {
        this(configXml, null);
    }

    @Deprecated
    public JpaStore(String persistenceUnit, String jndiProperty) {
        this._persistenceUnit = persistenceUnit;
        this._jndiProperty = jndiProperty;
    }

    @Deprecated
    public JpaStore(String persistenceUnit) {
        this(persistenceUnit, null);
    }

    private Session getSession() {
        if (this._persistenceUnit == null) {
            if (this._sessionFactory == null) {
                String jtaPlatform;
                String prop;
                Configuration cfg = new Configuration().configure(this._configXml);
                Properties properties = RTGovProperties.getProperties();
                if (this._jndiProperty != null && (prop = RTGovProperties.getProperty((String)this._jndiProperty)) != null) {
                    properties.setProperty("hibernate.connection.datasource", prop);
                }
                if ((jtaPlatform = RTGovProperties.getProperty((String)JTA_PLATFORM_PROPERTY)) == null) {
                    LOG.warning("JpaStore.jtaPlatform not set in overlord-rtgov.properties!");
                    this._isJta = false;
                } else {
                    properties.setProperty("hibernate.transaction.jta.platform", RTGovProperties.getProperty((String)JTA_PLATFORM_PROPERTY));
                }
                cfg.getProperties().putAll((Map<?, ?>)properties);
                this._sessionFactory = cfg.buildSessionFactory();
            }
            return this._sessionFactory.openSession();
        }
        if (this._entityManagerFactory == null) {
            String jtaPlatform;
            Properties properties = RTGovProperties.getProperties();
            if (this._jndiProperty != null) {
                properties.setProperty("hibernate.connection.datasource", RTGovProperties.getProperty((String)this._jndiProperty));
            }
            if ((jtaPlatform = RTGovProperties.getProperty((String)JTA_PLATFORM_PROPERTY)) == null) {
                LOG.warning("JpaStore.jtaPlatform not set in overlord-rtgov.properties!");
                this._isJta = false;
            } else {
                properties.setProperty("hibernate.transaction.jta.platform", RTGovProperties.getProperty((String)JTA_PLATFORM_PROPERTY));
            }
            this._entityManagerFactory = Persistence.createEntityManagerFactory((String)this._persistenceUnit, (Map)properties);
        }
        return (Session)this._entityManagerFactory.createEntityManager().unwrap(Session.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withJpa(JpaWork<T> work) {
        Session s = this.getSession();
        try {
            if (!this._isJta) {
                s.getTransaction().begin();
            }
            T result = work.perform(s);
            s.flush();
            if (!this._isJta) {
                s.getTransaction().commit();
            }
            T t = result;
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            s.close();
        }
    }

    public static interface JpaWork<T> {
        public T perform(Session var1);
    }
}

