/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.demos.query;

import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.QueryResultSet;

public class QueryDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/s-ramp-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "overlord";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running S-RAMP Query Demo ***\n");
        String endpoint = System.getProperty("sramp.endpoint");
        String username = System.getProperty("sramp.auth.username");
        String password = System.getProperty("sramp.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("S-RAMP Endpoint: " + endpoint);
        System.out.println("S-RAMP User: " + username);
        SrampAtomApiClient client = new SrampAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(QueryDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to skip the uploading of resources and just do the queries!");
        } else {
            SrampArchive archive = new SrampArchive(QueryDemo.class.getResourceAsStream("archive-package.sramp"));
            try {
                System.out.print("Uploading some content to the S-RAMP repository...");
                client.uploadBatch(archive);
                System.out.println("done!");
            }
            finally {
                SrampArchive.closeQuietly((SrampArchive)archive);
            }
        }
        System.out.print("Querying the S-RAMP repository for Schemas...");
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument");
        if (rset.size() >= 2L) {
            System.out.println("success: " + rset.size() + " Schema(s) found (expected AT LEAST 2)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " Schema(s) found (expected AT LEAST 2)");
        }
        System.out.print("Querying the S-RAMP repository for WSDLs...");
        rset = client.query("/s-ramp/wsdl/WsdlDocument");
        if (rset.size() >= 1L) {
            System.out.println("success: " + rset.size() + " WSDL(s) found (expected AT LEAST 1)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " WSDL(s) found (expected AT LEAST 1)");
        }
        System.out.print("Querying the S-RAMP repository for all artifacts version 1.1...");
        rset = client.query("/s-ramp[@version = '1.1']");
        if (rset.size() >= 2L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected AT LEAST 2)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected AT LEAST 2)");
        }
        System.out.print("Querying the S-RAMP repository for all artifacts version 1.2...");
        rset = client.query("/s-ramp[@version = '1.2']");
        if (rset.size() >= 1L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        }
        System.out.print("Querying the S-RAMP repository for a unique artifact by name + version...");
        rset = client.query("/s-ramp[@name = 'wsrm-1.1-schema-200702.xsd' and @version = '1.1']");
        if (rset.size() >= 1L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        }
        System.out.print("Querying the S-RAMP repository for a unique artifact by name + version (again)...");
        rset = client.buildQuery("/s-ramp[@name = ? and @version = ?]").parameter("wsrm-1.1-schema-200702.xsd").parameter("1.1").query();
        if (rset.size() >= 1L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected AT LEAST 1)");
        }
        System.out.print("Querying the S-RAMP repository for conflicting meta data...");
        rset = client.query("/s-ramp[@name = 'wsrm-1.1-schema-200702.xsd' and @version = '1.2']");
        if (rset.size() == 0L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected 0)");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected 0)");
        }
        System.out.print("Search for all artifacts with a name starting with 'w'...");
        rset = client.buildQuery("/s-ramp[xp2:matches(@name, ?)]").parameter("w.*").count(1).ascending().query();
        if (rset.size() == 1L) {
            System.out.println("success: " + rset.size() + " artifact(s) found (expected SOME :))");
        } else {
            System.out.println("** PROBLEM ** : " + rset.size() + " artifact(s) found (expected SOME)");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

