/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.models;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.jboss.resteasy.plugins.providers.atom.app.AppAccept;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.jboss.resteasy.plugins.providers.atom.app.AppService;
import org.jboss.resteasy.plugins.providers.atom.app.AppWorkspace;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.models.CoreModel;

public class CoreModelTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<service xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns=\"http://www.w3.org/2007/app\">\n  <workspace>\n    <atom:title type=\"text\" xmlns:atom=\"http://www.w3.org/2005/Atom\">Core Model</atom:title>\n    <collection href=\"http://example.org/s-ramp/core/XmlDocument\">\n      <atom:title type=\"text\" xmlns:atom=\"http://www.w3.org/2005/Atom\">XML Documents</atom:title>\n      <accept>application/xml</accept>\n      <categories fixed=\"yes\" xmlns:atom=\"http://www.w3.org/2005/Atom\">\n        <category scheme=\"urn:x-s-ramp:2010:type\" term=\"XmlDocument\"\n                  label=\"XML Document\" xmlns=\"http://www.w3.org/2005/Atom\"></category>\n        </categories>\n    </collection>\n    <collection href=\"http://example.org/s-ramp/core/document\">\n      <atom:title type=\"text\" xmlns:atom=\"http://www.w3.org/2005/Atom\">Documents</atom:title>\n      <accept>application/octet-stream</accept>\n      <categories fixed=\"yes\" xmlns:atom=\"http://www.w3.org/2005/Atom\">\n        <category scheme=\"urn:x-s-ramp:2010:type\" term=\"Document\"\n                  label=\"Document\" xmlns=\"http://www.w3.org/2005/Atom\"></category>\n      </categories>\n    </collection>\n    <collection href=\"http://example.org/s-ramp/core\">\n      <atom:title type=\"text\" xmlns:atom=\"http://www.w3.org/2005/Atom\">Core Model Objects\n      </atom:title>\n      <accept>application/zip</accept>\n      <categories fixed=\"yes\" xmlns:atom=\"http://www.w3.org/2005/Atom\">\n        <category scheme=\"urn:x-s-ramp:2010:type\" term=\"Document\"\n                  label=\"Document\" xmlns=\"http://www.w3.org/2005/Atom\"></category>\n        <category scheme=\"urn:x-s-ramp:2010:type\" term=\"XmlDocument\"\n          label=\"XML Document\" xmlns=\"http://www.w3.org/2005/Atom\"></category>\n      </categories>\n    </collection>\n  </workspace>\n</service>";

    public AppWorkspace getWorkspaceFromXML() throws Exception {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{AppService.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        AppService service = (AppService)unmarshaller.unmarshal((Reader)new StringReader(XML));
        AppWorkspace workspace = (AppWorkspace)service.getWorkspace().get(0);
        return workspace;
    }

    @Test
    public void unmarshallCoreModelWorkspace() throws Exception {
        AppWorkspace workspace = this.getWorkspaceFromXML();
        Assert.assertTrue((workspace.getCollection().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void compareCoreModelToSpecification() throws Exception {
        AppWorkspace coreModelWorkspace = CoreModel.getWorkSpace((String)"http://example.org");
        AppWorkspace expectedCoreModelWorkspace = this.getWorkspaceFromXML();
        Assert.assertEquals((Object)expectedCoreModelWorkspace.getTitle(), (Object)coreModelWorkspace.getTitle());
        Assert.assertEquals((Object)((AppCollection)expectedCoreModelWorkspace.getCollection().get(0)).getHref(), (Object)((AppCollection)coreModelWorkspace.getCollection().get(0)).getHref());
        long expectedSize = ((AppCollection)expectedCoreModelWorkspace.getCollection().get(0)).getAccept().size();
        long acceptSize = ((AppCollection)coreModelWorkspace.getCollection().get(0)).getAccept().size();
        Assert.assertTrue((expectedSize == acceptSize ? 1 : 0) != 0);
        ((AppAccept)((AppCollection)expectedCoreModelWorkspace.getCollection().get(0)).getAccept().get(0)).getContent();
    }

    @Test
    public void marshallCoreModel() throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AppService.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        AppWorkspace coreModelWorkspace = CoreModel.getWorkSpace((String)"http://example.org");
        AppService appService = new AppService();
        appService.getWorkspace().add(coreModelWorkspace);
        StringWriter writer = new StringWriter();
        JAXBElement element = new JAXBElement(new QName("", "app:service", "app"), AppService.class, (Object)appService);
        marshaller.marshal((Object)element, (Writer)writer);
        String actualXml = writer.toString();
        System.out.println(actualXml);
        Assert.assertTrue((boolean)actualXml.contains("atom:category"));
    }
}

