/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomExceptionMapper;
import org.overlord.sramp.atom.services.ArtifactResource;
import org.overlord.sramp.repository.PersistenceFactory;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Document;
import org.s_ramp.xmlns._2010.s_ramp.UserDefinedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.atom.TestUtils;

public class ArtifactResourceTest
extends BaseResourceTest {
    String uuid = null;

    @Before
    public void setUp() throws Exception {
        this.getProviderFactory().registerProvider(SrampAtomExceptionMapper.class);
        dispatcher.getRegistry().addPerRequestResource(ArtifactResource.class);
    }

    @AfterClass
    public static void cleanup() {
        PersistenceFactory.newInstance().shutdown();
    }

    @Test
    public void testDerivedArtifactCreate() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/ElementDeclaration"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(String.class);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        String stack = (String)response.getEntity();
        Assert.assertTrue((boolean)stack.contains("Failed to create artifact because 'ElementDeclaration' is a derived type."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPDFDocument() throws Exception {
        Document doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "sample.pdf";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/core/Document"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/pdf", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof Document));
            doc = (Document)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
            Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
            this.uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        PersistenceFactory.newInstance().shutdown();
        this.setUp();
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/core/Document/" + this.uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof Document));
        doc = (Document)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
        Assert.assertEquals((Object)"sample.pdf", (Object)doc.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
        ClientRequest request2 = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/core/Document/" + this.uuid + "/media")));
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-sample.pdf");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDroolsPkgDocument() throws Exception {
        UserDefinedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "defaultPackage.pkg";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/user/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/user/DroolsPkgDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
            doc = (UserDefinedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"DroolsPkgDocument", (Object)doc.getUserType());
            Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
            Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/user/DroolsPkgDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
        doc = (UserDefinedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
        Assert.assertEquals((Object)"defaultPackage.pkg", (Object)doc.getName());
        Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJPGDocument() throws Exception {
        UserDefinedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "photo.jpg";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/user/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/user/JpgDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
            doc = (UserDefinedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"JpgDocument", (Object)doc.getUserType());
            Assert.assertEquals((Object)2966447L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
            Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/user/JpgDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
        doc = (UserDefinedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)2966447L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
        Assert.assertEquals((Object)"photo.jpg", (Object)doc.getName());
        Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
        ClientRequest request2 = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/user/JpgDocument/" + uuid + "/media")));
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-photo.jpg");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBpmnUserDefinedDocumentCreate() throws Exception {
        UserDefinedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "Evaluation.bpmn";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/user/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/user/BpmnDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
            doc = (UserDefinedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"BpmnDocument", (Object)doc.getUserType());
            Assert.assertEquals((Object)12482L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
            Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/user/BpmnDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof UserDefinedArtifactType));
        doc = (UserDefinedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)12482L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(new QName("s-rampcontentSize"))));
        Assert.assertEquals((Object)"Evaluation.bpmn", (Object)doc.getName());
        Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(new QName("s-rampcontentType")));
        ClientResponse content = request.get(String.class);
        System.out.println("Content=" + (String)content.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWsdlDocumentCreate() throws Exception {
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/wsdl/WsdlDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)1643L, (Object)doc.getContentSize());
            Assert.assertEquals((Object)"application/xml", (Object)doc.getContentType());
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/wsdl/WsdlDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertNotNull((Object)arty);
        Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
        WsdlDocument wsdlDoc = (WsdlDocument)arty;
        Assert.assertEquals((Object)1643L, (Object)wsdlDoc.getContentSize());
        Assert.assertEquals((Object)"sample.wsdl", (Object)wsdlDoc.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNoSlug() throws Exception {
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        try {
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/wsdl/WsdlDocument"));
            request.body("application/xml", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)doc.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    @Test
    public void testFullPurchaseOrderXSD() throws Exception {
        Entry entry = this.doAddXsd();
        URI entryId = entry.getId();
        entry = this.doGetXsdEntry(entryId);
        String content = this.doGetXsdContent(entryId);
        this.verifyXsdContent(content);
        this.doUpdateXsdEntry(entry);
        entry = this.doGetXsdEntry(entryId);
        this.verifyEntryUpdated(entry);
        this.doUpdateXsdContent(entry);
        content = this.doGetXsdContent(entryId);
        this.verifyContentUpdated(content);
        this.deleteXsdEntry(entryId);
        this.verifyEntryDeleted(entryId);
    }

    private Entry doAddXsd() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        Assert.assertEquals((Object)artifactFileName, (Object)artifact.getXsdDocument().getName());
        return entry;
    }

    private Entry doGetXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        ClientResponse response = request.get(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertNotNull((Object)artifact.getXsdDocument());
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        return entry;
    }

    private String doGetXsdContent(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid + "/media")));
        ClientResponse response = request.get(String.class);
        return (String)response.getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyXsdContent(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            String expectedContent = TestUtils.convertStreamToString(POXsd);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            POXsd.close();
        }
    }

    private void doUpdateXsdEntry(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        xsdDocument.setDescription("** Updated description! **");
        Artifact arty = new Artifact();
        arty.setXsdDocument(xsdDocument);
        entry.setAnyOtherJAXBObject((Object)arty);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        request.body("application/atom+xml;type=entry", (Object)entry);
        request.put(Void.class);
    }

    private void verifyEntryUpdated(Entry entry) throws Exception {
        Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
        Assert.assertEquals((Object)"** Updated description! **", (Object)xsdDocument.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateXsdContent(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid + "/media")));
        String artifactFileName = "PO-updated.xsd";
        InputStream xsdStream = null;
        try {
            xsdStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            request.body("application/xml", (Object)xsdStream);
            request.put(Void.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsdStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xsdStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyContentUpdated(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        InputStream xsdStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/PO-updated.xsd");
        try {
            String expectedContent = TestUtils.convertStreamToString(xsdStream);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            xsdStream.close();
        }
    }

    private void deleteXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        request.delete(Void.class);
    }

    private void verifyEntryDeleted(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        ClientResponse response = request.get(String.class);
        String stacktrace = (String)response.getEntity();
        Assert.assertTrue((boolean)stacktrace.contains("Artifact not found."));
    }
}

