/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.overlord.sramp.atom.services.ArtifactResource;
import org.overlord.sramp.atom.services.FeedResource;
import org.overlord.sramp.atom.services.QueryResource;
import org.overlord.sramp.repository.jcr.JCRRepositoryCleaner;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.Property;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.atom.TestUtils;

public class FeedResourceTest
extends BaseResourceTest {
    @Before
    public void setUp() throws Exception {
        dispatcher.getRegistry().addPerRequestResource(ArtifactResource.class);
        dispatcher.getRegistry().addPerRequestResource(FeedResource.class);
        dispatcher.getRegistry().addPerRequestResource(QueryResource.class);
        new JCRRepositoryCleaner().clean();
    }

    @Test
    public void testArtifactFeed() throws Exception {
        int numEntries = 10;
        HashSet<String> uuids = new HashSet<String>();
        for (int i = 0; i < numEntries; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            uuids.add(uuid);
        }
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument?page=2&pageSize=2"));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertTrue((String)"Expected 2 entries.", (feed.getEntries().size() == 2 ? 1 : 0) != 0);
    }

    private Entry doAddXsd(String ... properties) throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        if (properties.length > 0) {
            Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
            for (int i = 0; i < properties.length; i += 2) {
                String propname = properties[i];
                String propvalue = properties[i + 1];
                Property prop = new Property();
                prop.setPropertyName(propname);
                prop.setPropertyValue(propvalue);
                xsdDocument.getProperty().add(prop);
            }
            String uuid = xsdDocument.getUuid();
            entry.setAnyOtherJAXBObject((Object)srampArtifactWrapper);
            request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put(Void.class);
        }
        return entry;
    }
}

