/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.services.ArtifactResource;
import org.overlord.sramp.atom.services.FeedResource;
import org.overlord.sramp.atom.services.QueryResource;
import org.overlord.sramp.repository.jcr.JCRRepositoryCleaner;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.Property;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.atom.TestUtils;

public class QueryResourceTest
extends BaseResourceTest {
    @Before
    public void setUp() throws Exception {
        dispatcher.getRegistry().addPerRequestResource(ArtifactResource.class);
        dispatcher.getRegistry().addPerRequestResource(FeedResource.class);
        dispatcher.getRegistry().addPerRequestResource(QueryResource.class);
    }

    @Before
    public void prepForTest() {
        new JCRRepositoryCleaner().clean();
    }

    @Test
    public void testQueries() throws Exception {
        int numEntries = 10;
        HashSet<String> uuids = new HashSet<String>();
        for (int i = 0; i < numEntries; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            uuids.add(uuid);
        }
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp?query=xsd/XsdDocument"));
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp"));
        MultipartFormDataOutput formData = new MultipartFormDataOutput();
        formData.addFormData("query", (Object)"xsd/XsdDocument", MediaType.TEXT_PLAIN_TYPE);
        request.body(MediaType.MULTIPART_FORM_DATA_TYPE, (Object)formData);
        response = request.post(Feed.class);
        feed = (Feed)response.getEntity();
        uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        String stampVal = UUID.randomUUID().toString();
        HashSet<String> allTidxVals = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            String propname = "tidx";
            String propval = String.valueOf(i);
            this.doAddXsd("foo", "bar", "stamp", stampVal, propname, propval);
            allTidxVals.add(propval);
        }
        String query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp?query=" + query)));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)5L, (long)feed.getEntries().size());
        query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp?page=0&pageSize=2&query=" + query)));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
        query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp?propertyName=tidx&propertyName=stamp&query=" + query)));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)5L, (long)feed.getEntries().size());
        HashSet<String> actualTidxVals = new HashSet<String>();
        for (Entry entry : feed.getEntries()) {
            Artifact arty = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            if (arty == null) continue;
            XsdDocument xsdDoc = arty.getXsdDocument();
            List properties = xsdDoc.getProperty();
            for (Property prop : properties) {
                if (!"tidx".equals(prop.getPropertyName())) continue;
                actualTidxVals.add(prop.getPropertyValue());
            }
        }
    }

    private Entry doAddXsd(String ... properties) throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        if (properties.length > 0) {
            Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
            for (int i = 0; i < properties.length; i += 2) {
                String propname = properties[i];
                String propvalue = properties[i + 1];
                Property prop = new Property();
                prop.setPropertyName(propname);
                prop.setPropertyValue(propvalue);
                xsdDocument.getProperty().add(prop);
            }
            String uuid = xsdDocument.getUuid();
            entry.setAnyOtherJAXBObject((Object)srampArtifactWrapper);
            request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put(Void.class);
        }
        return entry;
    }
}

