/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.overlord.sramp.atom.err.SrampAtomExceptionMapper;
import org.overlord.sramp.atom.services.AdHocQueryResource;
import org.overlord.sramp.atom.services.XsdDocumentResource;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampServerException;

public class SrampAtomApiClientTest
extends BaseResourceTest {
    @Before
    public void setUp() throws Exception {
        this.getProviderFactory().registerProvider(SrampAtomExceptionMapper.class);
        dispatcher.getRegistry().addPerRequestResource(XsdDocumentResource.class);
        dispatcher.getRegistry().addPerRequestResource(AdHocQueryResource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifact() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            Entry entry = client.uploadArtifact("xsd", "XsdDocument", is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)entry);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)entry.getTitle());
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactContent() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        URI uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            Entry entry = client.uploadArtifact("xsd", "XsdDocument", is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)entry);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)entry.getTitle());
            uuid = entry.getId();
        }
        finally {
            is.close();
        }
        InputStream content = client.getArtifactContent("xsd", "XsdDocument", uuid.toString());
        try {
            junit.framework.Assert.assertNotNull((Object)content);
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            junit.framework.Assert.assertTrue((String)"Unexpected content found.", (boolean)line1.startsWith("<?xml version=\"1.0\""));
            junit.framework.Assert.assertTrue((String)"Unexpected content found.", (boolean)line2.startsWith("<xsd:schema"));
        }
        finally {
            content.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuery() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        URI uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            Entry entry = client.uploadArtifact("xsd", "XsdDocument", is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)entry);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)entry.getTitle());
            uuid = entry.getId();
        }
        finally {
            is.close();
        }
        Feed feed = client.query("/s-ramp/xsd/XsdDocument", 0, 50, "name", false);
        List entries = feed.getEntries();
        boolean uuidFound = false;
        for (Entry entry : entries) {
            if (!entry.getId().equals(uuid)) continue;
            uuidFound = true;
        }
        junit.framework.Assert.assertTrue((String)"Failed to find the artifact we just added!", (boolean)uuidFound);
    }

    @Test
    public void testQueryError() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        try {
            Feed feed = client.query("12345", 0, 20, "name", false);
            Assert.fail((String)("Expected a remote exception from the s-ramp server, but got: " + feed));
        }
        catch (SrampServerException e) {
            String remoteTrace = e.getRemoteStackTrace();
            junit.framework.Assert.assertNotNull((Object)remoteTrace);
            junit.framework.Assert.assertTrue((boolean)remoteTrace.startsWith("org.overlord.sramp.query.xpath.XPathParserException: Invalid artifact set (step 2)."));
        }
    }
}

