/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.io.InputStream;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.client.ClientRequest;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampServerException;

public class SrampAtomApiClient {
    private String endpoint;

    public SrampAtomApiClient(String endpoint) {
        this.endpoint = endpoint;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    public Entry getFullArtifactEntry(String artifactModel, String artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            ClientResponse<Entry> response = request.get(Entry.class);
            return (Entry)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public Entry getFullArtifactEntry(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        return this.getFullArtifactEntry(artifactType.getModel(), artifactType.name(), artifactUuid);
    }

    public InputStream getArtifactContent(String artifactModel, String artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.endpoint, artifactModel, artifactType, artifactUuid);
            URL url = new URL(atomUrl);
            return url.openStream();
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public InputStream getArtifactContent(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        return this.getArtifactContent(artifactType.getModel(), artifactType.name(), artifactUuid);
    }

    public Entry uploadArtifact(String artifactModel, String artifactType, InputStream content, String artifactFileName) throws SrampClientException, SrampServerException {
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.endpoint, artifactModel, artifactType);
            ClientRequest request = new ClientRequest(atomUrl);
            if (artifactFileName != null) {
                request.header("Slug", artifactFileName);
            }
            request.body("application/xml", content);
            ClientResponse<Entry> response = request.post(Entry.class);
            return (Entry)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public Entry uploadArtifact(ArtifactType artifactType, InputStream content, String artifactFileName) throws SrampClientException, SrampServerException {
        return this.uploadArtifact(artifactType.getModel(), artifactType.name(), content, artifactFileName);
    }

    public Feed query(String srampQuery, int page, int pageSize, String orderBy, boolean ascending) throws SrampClientException, SrampServerException {
        try {
            String xpath = srampQuery;
            if (xpath == null) {
                throw new Exception("Please supply an S-RAMP x-path formatted query.");
            }
            if (xpath.startsWith("/s-ramp/")) {
                xpath = xpath.substring(8);
            }
            String atomUrl = this.endpoint;
            ClientRequest request = new ClientRequest(atomUrl);
            MultipartFormDataOutput formData = new MultipartFormDataOutput();
            formData.addFormData("query", (Object)xpath, MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("page", (Object)String.valueOf(page), MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("pageSize", (Object)String.valueOf(pageSize), MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("orderBy", (Object)orderBy, MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("ascending", (Object)String.valueOf(ascending), MediaType.TEXT_PLAIN_TYPE);
            request.body(MediaType.MULTIPART_FORM_DATA_TYPE, formData);
            ClientResponse<Feed> response = request.post(Feed.class);
            return (Feed)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }
}

