/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.mime.MimeTypes;
import org.overlord.sramp.client.ClientRequest;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampServerException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class SrampAtomApiClient {
    private String endpoint;

    public SrampAtomApiClient(String endpoint) {
        this.endpoint = endpoint;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    public Entry getFullArtifactEntry(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            ClientResponse<Entry> response = request.get(Entry.class);
            return (Entry)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public InputStream getArtifactContent(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampServerException {
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.endpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            URL url = new URL(atomUrl);
            return url.openStream();
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public Entry uploadArtifact(ArtifactType artifactType, InputStream content, String artifactFileName) throws SrampClientException, SrampServerException {
        String mimeType = artifactType.getMimeType();
        if (mimeType == null) {
            mimeType = MimeTypes.getContentType((String)artifactFileName);
        }
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.endpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType());
            ClientRequest request = new ClientRequest(atomUrl);
            if (artifactFileName != null) {
                request.header("Slug", artifactFileName);
            }
            if (mimeType != null) {
                request.header("Content-Type", mimeType);
            }
            request.body(artifactType.getMimeType(), content);
            ClientResponse<Entry> response = request.post(Entry.class);
            return (Entry)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ?> uploadBatch(SrampArchive archive) throws SrampClientException, SrampServerException {
        HashMap<String, Object> hashMap;
        File packageFile = null;
        FileInputStream packageStream = null;
        try {
            packageFile = archive.pack();
            packageStream = FileUtils.openInputStream((File)packageFile);
            ClientRequest request = new ClientRequest(this.endpoint);
            request.header("Content-Type", "application/zip");
            request.body("application/zip", packageStream);
            ClientResponse<MultipartInput> clientResponse = request.post(MultipartInput.class);
            MultipartInput response = (MultipartInput)clientResponse.getEntity();
            List parts = response.getParts();
            HashMap<String, Object> rval = new HashMap<String, Object>(parts.size());
            for (InputPart part : parts) {
                String contentId = (String)part.getHeaders().getFirst((Object)"Content-ID");
                String path = contentId.substring(1, contentId.lastIndexOf(64));
                HttpResponseBean rbean = (HttpResponseBean)part.getBody(HttpResponseBean.class, null);
                if (rbean.getCode() == 201) {
                    Entry entry = (Entry)rbean.getBody();
                    BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
                    rval.put(path, artifact);
                    continue;
                }
                if (rbean.getCode() != 409) {
                    throw new Exception("Unexpected return code '" + rbean.getCode() + "' for ID '" + contentId + "'.  The S-RAMP server is non-compliant.");
                }
                String errorReason = (String)rbean.getBody();
                SrampServerException exception = new SrampServerException("Conflict found for: " + path);
                exception.setRemoteStackTrace(errorReason);
                rval.put(path, exception);
            }
            hashMap = rval;
        }
        catch (SrampServerException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new SrampClientException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(packageStream);
                FileUtils.deleteQuietly((File)packageFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)packageStream);
        FileUtils.deleteQuietly((File)packageFile);
        return hashMap;
    }

    public void updateArtifactMetaData(BaseArtifactType artifact) throws SrampClientException {
        try {
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            String artifactUuid = artifact.getUuid();
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            Entry entry = SrampAtomUtils.wrapSrampArtifact((BaseArtifactType)artifact);
            request.body("application/atom+xml;type=entry", entry);
            request.put();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public void updateArtifact(BaseArtifactType artifact, InputStream content) throws SrampClientException {
        try {
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            String artifactUuid = artifact.getUuid();
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            request.body(type.getMimeType(), content);
            request.put();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public void deleteArtifact(String uuid, ArtifactType type) throws SrampClientException, SrampServerException {
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            String artifactUuid = uuid;
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            request.delete();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public Feed query(String srampQuery) throws SrampClientException, SrampServerException {
        return this.query(srampQuery, 0, 20, "name", true);
    }

    public Feed query(String srampQuery, int page, int pageSize, String orderBy, boolean ascending) throws SrampClientException, SrampServerException {
        try {
            String xpath = srampQuery;
            if (xpath == null) {
                throw new Exception("Please supply an S-RAMP x-path formatted query.");
            }
            if (xpath.startsWith("/s-ramp/")) {
                xpath = xpath.substring(8);
            }
            String atomUrl = this.endpoint;
            ClientRequest request = new ClientRequest(atomUrl);
            MultipartFormDataOutput formData = new MultipartFormDataOutput();
            formData.addFormData("query", (Object)xpath, MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("page", (Object)String.valueOf(page), MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("pageSize", (Object)String.valueOf(pageSize), MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("orderBy", (Object)orderBy, MediaType.TEXT_PLAIN_TYPE);
            formData.addFormData("ascending", (Object)String.valueOf(ascending), MediaType.TEXT_PLAIN_TYPE);
            request.body(MediaType.MULTIPART_FORM_DATA_TYPE, formData);
            ClientResponse<Feed> response = request.post(Feed.class);
            return (Feed)response.getEntity();
        }
        catch (SrampServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }
}

