/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.client.jar.ArtifactFilter;
import org.overlord.sramp.client.jar.CandidateArtifact;
import org.overlord.sramp.client.jar.DiscoveredArtifact;
import org.overlord.sramp.client.jar.JarToSrampArchive;
import org.overlord.sramp.client.jar.MetaDataFactory;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Document;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;

public class JarToSrampArchiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJarToSrampArchiveFile() throws Exception {
        InputStream resourceAsStream = null;
        File tempFile = null;
        FileOutputStream tempFileStream = null;
        JarToSrampArchive j2sramp = null;
        try {
            resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
            tempFile = File.createTempFile("j2sramp_test", ".jar");
            tempFileStream = FileUtils.openOutputStream((File)tempFile);
            IOUtils.copy((InputStream)resourceAsStream, (OutputStream)tempFileStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)resourceAsStream);
            IOUtils.closeQuietly(tempFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)resourceAsStream);
        IOUtils.closeQuietly((OutputStream)tempFileStream);
        try {
            j2sramp = new JarToSrampArchive(tempFile);
            File jarWorkDir = JarToSrampArchiveTest.getJarWorkDir(j2sramp);
            Assert.assertNotNull((Object)jarWorkDir);
            Assert.assertTrue((boolean)jarWorkDir.isDirectory());
            Collection files = FileUtils.listFiles((File)jarWorkDir, (String[])new String[]{"xsd", "wsdl"}, (boolean)true);
            Assert.assertEquals((long)2L, (long)files.size());
            HashSet<String> fnames = new HashSet<String>();
            for (File f : files) {
                fnames.add(f.getName());
            }
            Assert.assertTrue((boolean)fnames.contains("teetime.xsd"));
            Assert.assertTrue((boolean)fnames.contains("teetime.wsdl"));
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
            JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJarToSrampArchiveInputStream() throws Exception {
        InputStream resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
        JarToSrampArchive j2sramp = null;
        try {
            j2sramp = new JarToSrampArchive(resourceAsStream);
            File jarWorkDir = JarToSrampArchiveTest.getJarWorkDir(j2sramp);
            Assert.assertNotNull((Object)jarWorkDir);
            Assert.assertTrue((boolean)jarWorkDir.isDirectory());
            Collection files = FileUtils.listFiles((File)jarWorkDir, (String[])new String[]{"xsd", "wsdl"}, (boolean)true);
            Assert.assertEquals((long)2L, (long)files.size());
            HashSet<String> fnames = new HashSet<String>();
            for (File f : files) {
                fnames.add(f.getName());
            }
            Assert.assertTrue((boolean)fnames.contains("teetime.xsd"));
            Assert.assertTrue((boolean)fnames.contains("teetime.wsdl"));
        }
        finally {
            if (j2sramp != null) {
                j2sramp.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSrampArchive() throws Exception {
        InputStream resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
        JarToSrampArchive j2sramp = null;
        SrampArchive archive = null;
        try {
            j2sramp = new JarToSrampArchive(resourceAsStream);
            archive = j2sramp.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            Collection entries = archive.getEntries();
            Assert.assertEquals((long)2L, (long)entries.size());
            HashSet<String> paths = new HashSet<String>();
            for (SrampArchiveEntry entry : entries) {
                paths.add(entry.getPath());
            }
            Assert.assertEquals((long)2L, (long)entries.size());
            Assert.assertTrue((boolean)paths.contains("schema/teetime.xsd"));
            Assert.assertTrue((boolean)paths.contains("wsdl/teetime.wsdl"));
        }
        catch (Throwable throwable) {
            JarToSrampArchive.closeQuietly(j2sramp);
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
        SrampArchive.closeQuietly((SrampArchive)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomArtifactFilter() throws Exception {
        InputStream resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
        JarToSrampArchive j2sramp = null;
        SrampArchive archive = null;
        try {
            j2sramp = new JarToSrampArchive(resourceAsStream);
            j2sramp.setArtifactFilter(new ArtifactFilter(){

                public boolean accepts(CandidateArtifact artifact) {
                    return true;
                }
            });
            archive = j2sramp.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            Collection entries = archive.getEntries();
            Assert.assertEquals((long)16L, (long)entries.size());
            HashSet<String> paths = new HashSet<String>();
            for (SrampArchiveEntry entry : entries) {
                paths.add(entry.getPath());
            }
            Assert.assertEquals((long)16L, (long)entries.size());
            Assert.assertTrue((boolean)paths.contains("schema/teetime.xsd"));
            Assert.assertTrue((boolean)paths.contains("wsdl/teetime.wsdl"));
            Assert.assertTrue((boolean)paths.contains("com/redhat/ewittman/teetime/_2012/_09/wsdl/teetime_wsdl/TeeTimePortType.class"));
            Assert.assertTrue((boolean)paths.contains("META-INF/maven/com.redhat.ewittman/sample-web-service/pom.properties"));
        }
        catch (Throwable throwable) {
            JarToSrampArchive.closeQuietly(j2sramp);
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
        SrampArchive.closeQuietly((SrampArchive)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaData() throws Exception {
        InputStream resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
        JarToSrampArchive j2sramp = null;
        SrampArchive archive = null;
        try {
            j2sramp = new JarToSrampArchive(resourceAsStream);
            archive = j2sramp.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            SrampArchiveEntry entry = archive.getEntry("schema/teetime.xsd");
            Assert.assertNotNull((Object)entry);
            BaseArtifactType metaData = entry.getMetaData();
            Assert.assertNotNull((Object)metaData);
            Assert.assertTrue((boolean)(metaData instanceof XsdDocument));
            XsdDocument md = (XsdDocument)metaData;
            Assert.assertEquals((Object)"teetime.xsd", (Object)md.getName());
            Assert.assertNotNull((Object)md.getUuid());
        }
        catch (Throwable throwable) {
            JarToSrampArchive.closeQuietly(j2sramp);
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
        SrampArchive.closeQuietly((SrampArchive)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaDataFactory() throws Exception {
        InputStream resourceAsStream = JarToSrampArchiveTest.class.getResourceAsStream("sample-webservice-0.0.1.jar");
        JarToSrampArchive j2sramp = null;
        SrampArchive archive = null;
        try {
            j2sramp = new JarToSrampArchive(resourceAsStream);
            j2sramp.setMetaDataFactory(new MetaDataFactory(){

                public BaseArtifactType createMetaData(DiscoveredArtifact artifact) {
                    Document md = new Document();
                    md.setUuid(UUID.randomUUID().toString());
                    md.setName("custom-" + artifact.getName());
                    return md;
                }
            });
            archive = j2sramp.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            SrampArchiveEntry entry = archive.getEntry("schema/teetime.xsd");
            Assert.assertNotNull((Object)entry);
            BaseArtifactType metaData = entry.getMetaData();
            Assert.assertNotNull((Object)metaData);
            Assert.assertTrue((boolean)(metaData instanceof Document));
            Document md = (Document)metaData;
            Assert.assertEquals((Object)"custom-teetime.xsd", (Object)md.getName());
            Assert.assertNotNull((Object)md.getUuid());
        }
        catch (Throwable throwable) {
            JarToSrampArchive.closeQuietly(j2sramp);
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
        SrampArchive.closeQuietly((SrampArchive)archive);
    }

    public static File getJarWorkDir(JarToSrampArchive j2sramp) throws Exception {
        Field field = j2sramp.getClass().getDeclaredField("jarWorkDir");
        boolean oldAccessible = field.isAccessible();
        field.setAccessible(true);
        File workDir = (File)field.get(j2sramp);
        field.setAccessible(oldAccessible);
        return workDir;
    }
}

