/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditEntry;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.AbstractAuditingClientTest;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.audit.AuditEntrySummary;
import org.overlord.sramp.client.audit.AuditResultSet;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;

public class AuditingClientTest
extends AbstractAuditingClientTest {
    @Test
    public void testAuditing() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        BaseArtifactType doc = this.addXmlDoc();
        this.addXmlDoc();
        String artifactUuid = doc.getUuid();
        Thread.sleep(1000L);
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        AuditResultSet resultSet = client.getAuditTrailForArtifact(artifactUuid);
        Assert.assertNotNull((Object)resultSet);
        Assert.assertEquals((long)1L, (long)resultSet.getTotalResults());
        AuditEntrySummary summary = resultSet.get(0);
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)"junituser", (Object)summary.getWho());
        Assert.assertEquals((Object)"artifact:add", (Object)summary.getType());
        AuditEntry auditEntry = new AuditEntry();
        XMLGregorianCalendar now = dtFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        auditEntry.setType("junit:test1");
        auditEntry.setWhen(now);
        auditEntry.setWho("junituser");
        AuditEntry newEntry = client.addAuditEntry(artifactUuid, auditEntry);
        Assert.assertNotNull((Object)newEntry);
        Assert.assertEquals((Object)"junituser", (Object)newEntry.getWho());
        Assert.assertEquals((Object)"junit:test1", (Object)newEntry.getType());
        resultSet = client.getAuditTrailForArtifact(artifactUuid);
        Assert.assertNotNull((Object)resultSet);
        Assert.assertEquals((long)2L, (long)resultSet.getTotalResults());
        summary = resultSet.get(0);
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)"junituser", (Object)summary.getWho());
        Assert.assertEquals((Object)"junit:test1", (Object)summary.getType());
        summary = resultSet.get(1);
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)"junituser", (Object)summary.getWho());
        Assert.assertEquals((Object)"artifact:add", (Object)summary.getType());
        auditEntry = client.getAuditEntry(artifactUuid, summary.getUuid());
        Assert.assertNotNull((Object)newEntry);
        Assert.assertEquals((Object)"junituser", (Object)auditEntry.getWho());
        Assert.assertEquals((Object)"artifact:add", (Object)auditEntry.getType());
        resultSet = client.getAuditTrailForUser("junituser");
        Assert.assertNotNull((Object)resultSet);
        Assert.assertEquals((long)3L, (long)resultSet.getTotalResults());
    }
}

