/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.audit;

import java.util.Iterator;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.overlord.sramp.client.audit.AuditEntrySummary;
import org.overlord.sramp.common.SrampConstants;

public class AuditResultSet
implements Iterable<AuditEntrySummary> {
    private Feed currentFeed;

    public AuditResultSet(Feed feed) {
        this.currentFeed = feed;
    }

    public long size() {
        return this.currentFeed.getEntries().size();
    }

    public long getTotalResults() {
        Object totalResultsAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        if (totalResultsAttr != null) {
            return Long.parseLong((String)totalResultsAttr);
        }
        return -1L;
    }

    public int getItemsPerPage() {
        Object itemsPerPageAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME);
        if (itemsPerPageAttr != null) {
            return Integer.parseInt((String)itemsPerPageAttr);
        }
        return -1;
    }

    public int getStartIndex() {
        Object startIndexAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_START_INDEX_QNAME);
        if (startIndexAttr != null) {
            return Integer.parseInt((String)startIndexAttr);
        }
        return -1;
    }

    public AuditEntrySummary get(int index) {
        if (index >= this.currentFeed.getEntries().size()) {
            return null;
        }
        return new AuditEntrySummary((Entry)this.currentFeed.getEntries().get(index));
    }

    @Override
    public Iterator<AuditEntrySummary> iterator() {
        return new DelegatingIterator(this.currentFeed.getEntries().iterator());
    }

    private static class DelegatingIterator
    implements Iterator<AuditEntrySummary> {
        private Iterator<Entry> delegate;

        public DelegatingIterator(Iterator<Entry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public AuditEntrySummary next() {
            return new AuditEntrySummary(this.delegate.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

